{*<!--
  /*
   *Copyright (C) www.vtiger.com. All rights reserved.
   * @license Proprietary
  */
-->*}

{literal}
    <div class="cp-table-container" ng-show="documentsrecords">
        <div ng-if="documents_rollup_support" class="smaller-cpSwitch d-inline-block position-relative" style="margin-left:16px;margin-bottom: 8px;">
            <label class="cp-switch">
                <div class="d-inline-block"> {{'Roll up'|translate}} </div>
                <input ng-click="documentsRollup($event)" ng-checked="documents_rollup" type="checkbox" name="roll_up" class="invisible" style="margin:0px -4px;" /> 
                <span class="checkmark c-pointer position-relative" style="top: 4px;"></span>
            </label>
        </div>
        <div class="table-responsive">
            <table class="table table-hover table-condensed table-detailed dataTable no-footer">
                <thead>
                    <tr class="listViewHeaders">
                        <th ng-hide="header=='id'" class="medium" ng-if="documentsheaders.length > 0" style="width:100px!important;">
                            <a class="listViewHeaderValues">{{'Actions'|translate}}</a>
                        </th>
                        <th ng-hide="!documentsheader || documentsheader=='id'" ng-repeat="documentsheader in documentsheaders" nowrap="" class="medium">
                            <a href="javascript:void(0);" class="listViewHeaderValues" translate="{{documentsheader}}">{{documentsheader}}</a>
                        </th>
                        <th class='listViewLastActionHeader'> </th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="listViewEntries" ng-repeat="documentrecord in documentsrecords">
                        <td ng-hide="documentsheader=='id'" class="listViewEntryValue medium" nowrap="" style='cursor: pointer;'>
                            <span ng-if="isDocEditable !=='0' && record.isclosed != '1'"class="fa fa-edit actionIcon" ng-click="editRelRecord('Documents',documentrecord)"></span>
                            <span ng-if="documentrecord['file_url']!=null && isDocPreviewAllowed !=='0'" class="fa fa-eye actionIcon" ng-click="previewFile('Documents', documentrecord)"></span>
                            <ng-switch on="documentrecord['filename'].indexOf('://')" ng-if="documentrecord.filetype != '' && documentrecord.documentExists && isDocDownloadAllowed !=='0'">
                                <span ng-switch-when="-1" class="fa fa-download actionIcon" ng-click="downloadFile('Documents',documentrecord.id,documentrecord.parentId ? documentrecord.parentId : id)"></span>
                                <a ng-switch-default href="{{documentrecord['filename']}}" target="_blank" class="fa fa-download actionIcon"></a>
                            </ng-switch>
                        </td>
                        <td ng-hide="documentsheader=='id'" ng-repeat="documentsheader in documentsheaders" class="listViewEntryValue medium" ng-click="ChangeLocation('Documents',documentrecord)">
                            <a ng-href="index.php?module=Documents&view=Detail&id={{documentrecord.id}}"></a>
                            <span ng-if="::isRelatedRecordDateTimeField(documentsheader,relatedRecordsDateTimeFields) === false && isRelatedRecordDateField(documentsheader, relatedRecordsDateFields) === false">{{documentrecord[documentsheader]}}</span>
                            <span ng-if="::isRelatedRecordDateTimeField(documentsheader,relatedRecordsDateTimeFields) === true">{{documentrecord[documentsheader]|amUtc|amLocal|amDateFormat:'YYYY-MM-DD HH:mm:ss'|dateTimeFormat}}</span>
							<span ng-if="::isRelatedRecordDateField(documentsheader, relatedRecordsDateFields) === true">{{documentrecord[documentsheader]|dateFormat}}</span>
                        </td>
                        <td class="listViewLastActionColumn">
                            <div class='actionsContainer'>
                                <span class="action openin_newtab" title="{{'Open in new tab'|translate}}" ng-click="ChangeLocation('Documents',documentrecord, '_blank')">
                                    <i class="fa fa-external-link"> </i>
                                </span>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <p ng-if="loadingData" class="text-muted alert alert-info">{{'Loading'|translate}}...</p>
    <a ng-if="!loadingData && !documentsLoaded && !noDocuments" ng-click="loadDocumentsPage(documentsPageNo)">{{'more'|translate}}...</a>
    <p ng-if="!loadingData && noDocuments && documentsPageNo > 1" class="text-muted">{{'No more documents'|translate}}</p>
    <p ng-if="!loadingData && !documentsrecords.length" class="text-muted alert alert-warning">{{'No more documents'|translate}}</p>
{/literal}