/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

portalapp.controller("Home_Component",function( $scope, $api, $webapp, $modal, sharedModalService, $translatePartialLoader ,$controller,$rootScope) {
	/*@ngInject*/
	$translatePartialLoader.addPart( 'home' );
	$scope.supportNotification = false;
	$scope.announcementExists = false;
	$scope.charts = false;
	$scope.profileFetched = false;
        $scope.module = 'home';
		
	$scope.fetchAnnouncement = function () {
		$api.get( 'Portal/FetchAnnouncement' )
			.success( function ( result ) {
				if ( result.announcement !== '' ) {
					$scope.announcementExists = true;
					$scope.announcement = result.announcement;
				} else if ( result.announcement == '' && ( result.message === 'Contacts module is disabled' || result.message === 'Login failed' ) ) {
					alert( result.message );
					localStorage.clear();
					window.location.href = "index.php?view=Logout";
				}
			} );
	}

	$scope.orgName = function () {
		$api.getCompanyTitle().success( function ( profile ) {
            if ( profile.result !== null ) {
                $scope.accountDetails = profile.result;
                $scope.org = $scope.accountDetails;
            }
            $scope.profileFetched = true;
	} );
}

	$scope.fetchShortcuts = function () {
		$api.get( 'Portal/FetchShortcuts' )
			.success( function ( result ) {
				var availableModules = $scope.$parent.modules;

				if ( result.shortcut ) {
					$scope.showShortcuts = true;
					if ( availableModules[ 'HelpDesk' ] !== undefined && result.shortcut.HelpDesk !== undefined ) {
						var uiLabel = availableModules[ 'HelpDesk' ].uiLabel;
						result.shortcut[ uiLabel ] = result.shortcut.HelpDesk;
						if ( uiLabel !== 'HelpDesk' )
							delete result.shortcut[ 'HelpDesk' ];
					}
					if ( availableModules[ 'Documents' ] !== undefined && result.shortcut.Documents !== undefined ) {
						var uiLabel = availableModules[ 'Documents' ].uiLabel;
						result.shortcut[ uiLabel ] = result.shortcut.Documents;
						if ( uiLabel !== 'Documents' )
							delete result.shortcut[ 'Documents' ];
					}

					if ( availableModules[ 'Cases' ] !== undefined && result.shortcut.Cases !== undefined ) {
						var uiLabel = availableModules[ 'Cases' ].uiLabel;
						result.shortcut[ uiLabel ] = result.shortcut.Cases;
						if ( uiLabel !== 'Cases' )
							delete result.shortcut[ 'Cases' ];
					}

					$scope.shortcuts = result.shortcut;
				} else {
					$scope.showShortcuts = false;
				}
			} )
	}
	$scope.openShortcut = function ( module, action ) {
		var actionConfig = {
			'LBL_ADD_DOCUMENT': 'Documents',
			'LBL_CREATE_TICKET': 'HelpDesk',
			'LBL_CREATE_CASE':'Cases'
		};
		var serviceConfig = {
			'LBL_OPEN_TICKETS': 'HelpDesk',
			'LBL_OPEN_CASES':'Cases'
		};
		if ( actionConfig.hasOwnProperty( action ) ) {
			sharedModalService.prepForModal( actionConfig[ action ] );
		}
		if ( serviceConfig.hasOwnProperty( action ) ) {
			sharedModalService.loadService( serviceConfig[ action ] );
		}

	}
	
	$scope.showAccountRepresentative = function(fieldName) {
		$scope.accountRepresentativeDetails = $scope.accountRepresentativesInfo[fieldName];
		$modal.open({
				templateUrl: 'accountRepresentative.template',
				controller : function($scope, $modalInstance) {
					$scope.cancel = function () {
						$modalInstance.dismiss('cancel');
					 }
				},
				backdrop: 'static',
				keyboard: 'false',
				scope : $scope,
				size : 'md'
			});
	}
	
	$scope.fetchRecentRecords = function () {
		$scope.activateRecentTickets = false;
		var availableModules = JSON.parse(localStorage.getItem('modules'));
		$api.get( 'Portal/FetchRecentRecords' )
			.success( function ( result ) {
				if ( result.records ) {
					if ( result.records.HelpDesk !== undefined && result.records.HelpDesk !== '' ) {
						var uiLabel = availableModules[ 'HelpDesk' ].uiLabel;
						result.records[ uiLabel ] = result.records.HelpDesk;
						if ( uiLabel !== 'HelpDesk' ){
							delete result.records[ 'HelpDesk' ];
						}
						$scope.recentTickets = result.records[ uiLabel ];
						$scope.ticketsUiLabel = uiLabel;
						$scope.activateRecentTickets = true;
					}
					if ( result.records.Cases !== undefined && result.records.Cases !== '' ) {
						var uiLabel = availableModules[ 'Cases' ].uiLabel;
						result.records[ uiLabel ] = result.records.Cases;
						if ( uiLabel !== 'Cases' ){
							delete result.records[ 'Cases' ];
						}
						$scope.activateRecentCases = true;
						$scope.recentCases = result.records[ uiLabel ];
						$scope.casesUiLabel = uiLabel;
					}
					if ( result.records.Documents !== undefined && result.records !== '' ) {
						var uiLabel = availableModules[ 'Documents' ].uiLabel;
						result.records[ uiLabel ] = result.records.Documents;
						if ( uiLabel !== 'Documents' ){
							delete result.records[ 'Documents' ];
						}
					}
					if ( result.records.Faq !== undefined && result.records.Faq !== '' ) {
						var uiLabel = availableModules[ 'Faq' ].uiLabel;
						result.records[ uiLabel ] = result.records.Faq;
						if ( uiLabel !== 'Faq' ){
							delete result.records[ 'Faq' ];
						}
					}
					$scope.recentRecords = result.records;
				}
			} )
	}

	$scope.fetchSupportNotification = function () {
		var notify = localStorage.getItem( 'supportNotification' );
		if ( notify !== null ) {
			$scope.supportNotification = true;
			$scope.notification = notify;
		}
	}

	$scope.fetchCharts = function () {
		$api.get( 'Portal/FetchCharts' )
			.success( function ( data ) {
				var enabledCharts = data;
				$scope.enabledCharts = data;
				$scope.chartCount = data.count;
			} )
	}
	
	$scope.fetchProfile = function () {
		var profileModules = JSON.parse(localStorage.getItem('profileModules'));
		if (!profileModules) profileModules = $scope.profileModules;
		$api.get('Portal/FetchProfile', {modules: profileModules})
			.success(function (profile) {
			var contactDetails = profile.customer_details;
			var firstNameFieldLabel = contactDetails.editLabels['firstname'];
			$scope.firstName = contactDetails.record[firstNameFieldLabel];
		})
	}
	
	$scope.fetchGreetingType = function () {
		$api.get('Portal/FetchGreetingType')
			.success(function (result) {
			$scope.greetingType = result.greetingType;
		})
	}
	
	$scope.fetchGreetingMessage = function () {
		var currentDateTime = moment().unix(); 
		var currentDate = moment().format('YYYY-MM-DD');
		var greetingMessage;
		if(currentDateTime >= moment(currentDate + ' 05:00:00').unix() && currentDateTime <= moment(currentDate + ' 12:30:00').unix()) {
			greetingMessage = 'LBL_GOODMORNING';
		} else if(currentDateTime > moment(currentDate + ' 12:30:00').unix() && currentDateTime <= moment(currentDate + ' 17:00:00').unix()) {
			greetingMessage = 'LBL_GOODAFTERNOON';
		} else {
			greetingMessage = 'LBL_GOODEVENING';
		}
		$scope.greetingMessage = greetingMessage;
	}
	
	$scope.fetchAccountRepresentatives = function() {
		$api.get('Portal/FetchAccountRepresentatives').success(function (result) {
			if(result.accountRepresentativesInfo !== undefined) {
				$scope.accountRepresentativesInfo = result.accountRepresentativesInfo;
			}
		})
	}
	
	$scope.chartClassEven = function ( length ) {
		if ( $scope.chartCount % 2 == 0 && length == 0 || length % 2 !== 0 ) {
			return true;
		}
	}
	$scope.chartClassOdd = function ( length ) {
		if ( $scope.chartCount > 2 && length == 0 || length % 2 == 0 ) {
			return true;
		}
	}

	$scope.applyChartClass  = function(index){
		var lengthIsEven = false;
		if($scope.chartCount % 2===0){
			lengthIsEven = true;
		}
		if(lengthIsEven && index % 2===0){
			return 'col-lg-6 col-md-6 col-xs-9 col-sm-9';
		}else if(lengthIsEven && index % 2!==0){
			return 'col-lg-6 col-md-6 col-xs-9 col-sm-9';
		}
		if(!lengthIsEven && index % 3>0){
			return 'col-md-6 col-lg-6 col-sm-9 col-xs-9';
		}else if(!lengthIsEven && index % 3===0){
			return 'col-lg-12 col-md-12 col-xs-9 col-sm-9';
		}
	}

	$scope.determineStatus = function ( status ) {
		if ( status === 'Closed' ) {
			return 'label-success';
		} else if ( status === 'Open' ) {
			return 'label-danger';
		} else if ( status === 'In Progress' ) {
			return 'label-warning';
		} else if ( status === 'Wait For Response' ) {
			return 'label-info';
		} else if (status === 'Closed') {
			return 'label-success';
		} else if ( status === 'Wait' ) {
			return 'label-info';
		} else if (status === 'New'){
			return 'label-danger';
		} else if (status === 'Assigned'){
			return 'label-info';
		} else if (status === 'Rsolved'){
			return 'label-success';
		}else return 'label-primary';
	}
	$scope.moduleCheck = function ( module ) {
		if ( $scope.$parent.modules[ 'Cases' ].uiLabel === module ) {
			$scope.ticketsUiLabel = module;
			return true;
		} else {
			return false;
		}
	}
	$controller,("HelpDesk_IndexView_Component",({$scope:$scope}));

	$controller,("Documents_IndexView_Component",({$scope:$scope}));

	$controller,("Cases_IndexView_Component",({$scope:$scope}));
	//Wait for modules fetched from fetchModules

    $scope.$root.$on('LoginUser.Ready', function () {
        loadContents();
    });

	$scope.searchEnabled = false;

	function loadContents() {
		$webapp.busy();
		$scope.orgName();
		$scope.fetchAnnouncement();
		$scope.fetchCharts();
		$scope.fetchShortcuts();
		$scope.fetchRecentRecords();
		$scope.fetchSupportNotification();
		$scope.fetchProfile();
		$scope.fetchGreetingType();
		$scope.fetchGreetingMessage();
		$scope.fetchAccountRepresentatives();
		$webapp.busy( false );
		if ( localStorage.getItem( 'currentStatus' ) !== undefined ) {
			localStorage.removeItem( 'currentStatus' );
		}
	}

	$scope.isObj = function ( content ) {
		if ( angular.isObject( content ) )
			return true;
	}

	$scope.loadRecentRecord = function ( module, id ) {
		var availableModules = $scope.$parent.modules;
		if ( availableModules[ 'HelpDesk' ] !== undefined && availableModules[ 'HelpDesk' ].name === module ) {
			window.location.href = "index.php?module=HelpDesk&view=Detail&id=" + id;
		}
		if ( availableModules[ 'Documents' ] !== undefined && availableModules[ 'Documents' ].uiLabel === module ) {
			window.location.href = "index.php?module=Documents&view=Detail&id=" + id;
		}
		if ( availableModules[ 'Faq' ] !== undefined && availableModules[ 'Faq' ].uiLabel === module ) {
			window.location.href = "index.php?module=Faq&record=" + id;
		}
		if ( availableModules[ 'Cases' ] !== undefined && availableModules[ 'Cases' ].name === module ) {
			window.location.href = "index.php?module=Cases&view=Detail&id=" + id;
		}
	}

	$scope.ifNotTickets = function ( module ) {
		var availableModules = $scope.$parent.modules;
		if ( availableModules[ 'HelpDesk' ] !== undefined && availableModules[ 'HelpDesk' ].uiLabel === module ) {
			return false;
		}
		if ( availableModules[ 'Cases' ] !== undefined && availableModules[ 'Cases' ].uiLabel === module ) {
			return false;
		}
		return true;
	}

});
