/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

/**
 * Globals
 */
function parseBool( input ) {
	if ( typeof input === 'string' && input.toLowerCase() == 'true' )
		return true;
	if ( input === true )
		return true;
	return ( parseInt( input ) > 0 );
}

function getDateFormat() {
	var dateFormat = document.documentElement.getAttribute('date-format');
	return dateFormat.replace('mm', 'MM');
}

function getTimeFormat() {
	if(parseInt(document.documentElement.getAttribute('time-format')) === 12) {
		return 'hh:mm A';
	} else {
		return 'HH:mm';
	}
}

function getDateTimeFormat() {
	return getDateFormat().toUpperCase() + ' ' + getTimeFormat();
}

/**
 * AngularJS
 */
var portalapp = angular.module( 'portalapp', [ 'ui.bootstrap', 'ngProgress', 'monospaced.elastic', 'pascalprecht.translate', 'ui.select', 'ui.bootstrap.timepicker', 'ngSanitize', 'ngCsv', 'xeditable','angularMoment'] );

portalapp.filter( 'dateDiffString', function ( $sce ) {
	/*@ngInject*/
	return function ( utcTime ) {
        var pluralize = function(value, string) {
            return value + ' ' + ((value === 1) ? string : string+'s');
        }
        
        var currentTime = new Date();
        var utcTimeParts = utcTime.trim().split(' ');
        var givenTime = new Date(utcTimeParts[0]+'T'+utcTimeParts[1]+'Z');
        var seconds = Math.floor((currentTime - givenTime)/1000);
        var prefix, suffix;

        var diffString = '';
        if(seconds === 0) {
            diffString = 'just now';
        }
        if(seconds > 0) {
            prefix = '';
            suffix = ' ago';
        } else {
            prefix = 'due ';
            suffix = '';
            seconds = -seconds;
        }

        var minutes = Math.floor(seconds / 60);
        var hours = Math.floor(minutes / 60);
        var days = Math.floor(hours / 24);
        var months = Math.floor(days / 30);
        var years = Math.floor(days / 365);

        if(seconds && seconds < 60) {
            diffString = prefix + 'few seconds' + suffix;
        } else if(minutes && minutes < 60) {
            diffString = prefix + pluralize(minutes, 'minute') + suffix;
        } else if(hours && hours < 24) {
            diffString = prefix + pluralize(hours, 'hour') + suffix;
        } else if(days && days < 30) {
            diffString = prefix + pluralize(days, 'day') + suffix;
        } else if((months && months < 12) || (years && years < 1)) {
            diffString = prefix + pluralize(months, 'month') + suffix;
        } else if(months && months > 11) {
            diffString = prefix + pluralize(years, 'year') + suffix;
        }
        return diffString;
	};
});

portalapp.filter( 'unsafe', function ( $sce ) {
	/*@ngInject*/
	return function ( val ) {
		return $sce.trustAsHtml( val );
	};
} );

portalapp.filter('linkify',function(){
	return function(text){
		var options = {'TLDs':267};
		var linkedText = anchorme.js(text,options);
		var div = angular.element('<div/>')[0];
		div.innerHTML = linkedText;
		var links = div.getElementsByTagName('a');
		if(links.length){
			for(var i in links){
				var anchor = links[i];
				try{
					anchor.setAttribute('target','_blank');
				}catch(err){
					console.log(err);
				}
			}
		}
		return div.innerHTML;
	}
});

portalapp.filter( 'orderModulesBy', function () {
	return function ( modules, attribute, reverse ) {
		var sorted = [];
		angular.forEach( modules, function ( module ) {
			if ( !angular.isObject( module ) ) {
				return;
			}
			sorted.push( module );
		} );
		sorted.sort( function ( a, b ) {
			return ( parseInt( a.order ) > parseInt( b.order ) ? 1 : -1 );
		} );

		if ( reverse )
			sorted.reverse();
		return sorted;
	}
} );


portalapp.factory( '$deferred',['$q',function ( $q ) {

	return {
		create: function () {
			// $q.promise does not provide ("then" callback)
			// we try to implement by pushing error and result to "then" callback.
			var deferred = $q.defer();

			// Backup actual then handler, to provide customized promise methods (then, success, error)
			var deferredThen = deferred.promise.then;

			// Customize handlers
            var thenFn = function() {
            }, successFn = null, errorFn = null;
						return deferred.promise.success = function ( fn ) {
							successFn = fn;
						},
						deferred.promise.error = function ( fn ) {
							errorFn = fn;
						},
						deferred.promise.then = function ( fn ) {
							thenFn = fn;
						},
						deferredThen.call(deferred.promise,function ( result ) {
							successFn ? successFn( result ) : thenFn( null, result );
						}, function ( err ) {
							errorFn ? errorFn( err ) : thenFn( err, null );
						} ),deferred
					}
				}
}]);

portalapp.factory( '$cache', function () {
    return {
        'get' : function(key) {
            var value = localStorage.getItem(key);
            if(value) {
                try{
                    var parsedValue = JSON.parse(value);
                    value = parsedValue;
                }catch(e) {}
            }
            return value;
        },
        'set' : function(key, value) {
            if(typeof value == 'object') {
                value = JSON.stringify(value);
            }
            localStorage.setItem(key, value);
        },
    }
});

/**
 * Any local preferences can be saved here
 * Usage :
 * $preferences.set(key, value);
 * $preferences.get(key);
 */  
portalapp.factory( '$preferences', function ($cache) {
    function getKey() {
        return 'user_client_preferences';
    }
    
    return {
        'getAll' : function() {
            var cacheKey = getKey();
            var preferences = $cache.get(cacheKey);
            return preferences || {};
        },
        'get' : function(key) {
            var preferences = this.getAll();
            var value = null;
            if(typeof preferences == 'object' && preferences[key]) {
                value = preferences[key];
            }
            return value;
        },
        'set' : function(key, value) {
            var preferences = this.getAll();
            preferences[key] = value;
            var cacheKey = getKey();
            $cache.set(cacheKey, JSON.stringify(preferences));
        },
    }
});

portalapp.factory( '$api', function ( $deferred, $http, $cache ) {
	/*@ngInject*/
	var APIBASE = 'index.php';

	function _invoke( method, path, params ) {
		// Derive target module & api through path
		var pathParts = path.split( '/' );
		if ( typeof params == 'undefined' )
			params = {};
		params.module = pathParts.shift();
		if ( pathParts.length )
			params.api = pathParts.shift();

		var options = {
			method: method,
			url: APIBASE
		}
		if ( params ) {
			if ( method == 'GET' )
				options.params = params;
			else
				options.data = params;
		}
		var deferred = $deferred.create();
		$http( options )
			.success( function ( data, status, headers, config ) {
				data.success ?
					deferred.resolve( data.result, null ) :
					deferred.reject( data.error ? data.error.message : "No response" );
			} )
			.error( function ( data, status, headers, config ) {
				deferred.reject( data ? data : "ERR: " + status );
			} );
		return deferred.promise;
	}
	return {
		// http://docs.angularjs.org/api/ng.$http
		'get': function ( path, params ) {
			return _invoke.apply( null, [ 'GET', path, params ] );
		},
		'post': function ( path, params ) {
			return _invoke.apply( null, [ 'POST', path, params ] );
		},
        'getDescribe' : function(module, params) {
            var deferred = $deferred.create();
            var cacheKey = 'DescribeModule_'+module;
            var describe = $cache.get(cacheKey);
            if(describe) {
                deferred.resolve(describe);
            } else {
                this.get(module + '/DescribeModule', params).success(function (describe) {
                    $cache.set(cacheKey, describe);
                    deferred.resolve(describe);
                });
            }
            return deferred.promise;
        },
        getCompanyDetails : function() {
            var deferred = $deferred.create();
            var cacheKey = 'CompanyDetails';
            var details = $cache.get(cacheKey);
            if(details) {
                deferred.resolve(details);
            } else {
                this.get('/FetchCompanyDetails').success(function (details) {
                    $cache.set(cacheKey, details);
                    deferred.resolve(details);
                });
            }
            return deferred.promise;
        },
        getCompanyTitle : function() {
            var deferred = $deferred.create();
            var cacheKey = 'CompanyTitle';
            var title = $cache.get(cacheKey);
            if(title) {
                deferred.resolve(title);
            } else {
                this.get('Portal/FetchCompanyTitle').success(function (title) {
                    $cache.set(cacheKey, title);
                    deferred.resolve(title);
                });
            }
            return deferred.promise;
        },
        fetchRelatedModules : function(module) {
            var deferred = $deferred.create();
            var cacheKey = module+"_RelatedModules";
            var relatedModules = $cache.get(cacheKey);
            if(relatedModules) {
                deferred.resolve(relatedModules);
            } else {
                this.get(module + '/FetchRelatedModules').success(function (relatedModules) {
                    $cache.set(cacheKey, relatedModules);
                    deferred.resolve(relatedModules);
                });
            }
            return deferred.promise;
        },
        getLanguageStrings : function(module, paths) {
            var deferred = $deferred.create();
			var language = document.documentElement.lang;
            var cacheKey = module+"_"+language+"_LanguageStrings";
            var strings = $cache.get(cacheKey);
            if(strings) {
                deferred.resolve(strings);
            } else {
                var strings = {};
                var counter = 0;
                for(var i in paths) {
                    $http.get(paths[i]).success(function (result) {
                        counter++;
                        if(typeof result == 'object') {
                            angular.extend(strings, result);
                        }

                        if(counter == paths.length) {
                            // Once all paths are requested then resolve
                            $cache.set(cacheKey, strings);
                            deferred.resolve(strings);
                        }
                    }).error(function (error) {
                        deferred.resolve(strings);
                    });
                }
            }
            return deferred.promise;
        },
	}

} );

portalapp.factory( '$webapp', function ( $deferred, $api, ngProgress ) {
	/*@ngInject*/
	ngProgress.color( '#10cfbd' );
	ngProgress.height( '3px' );
	var busyIndicator = jQuery( '#busy-indicator' );

	function busy( on ) {
		if ( typeof on == 'undefined' )
			on = true;
		if ( busyIndicator.length ) {
			if ( on ) {
				busyIndicator.removeClass( 'hide' )
					.show();
			} else {
				busyIndicator.addClass( 'hide' )
					.hide();
			}
		} else {
			if ( on ) {
				ngProgress.reset();
				ngProgress.start();
			} else {
				ngProgress.complete();
			}
		}
	}
	return {
		busy: busy,
	}
} );

portalapp.directive( 'hpSelectric', function ( $timeout, $rootScope ) {
	/*@ngInject*/
	return {
		restrict: 'E',
		scope: {
			items: '=',
			ngModel: '='
		},
		replace: true,
		template: '<select id="cn" class="col-lg-12 col-md-12 col-sm-12 col-xs-12" ng-options="item.label for item in items"></select>',
		link: function ( scope, element, attrs ) {},
		compile: function ( scope, element, attrs ) {
			return {
				pre: function ( scope, element, attrs, ngModel ) {
					scope.$watch( 'items', function ( v ) {
						if ( v ) {
							if ( element.context.nodeName == 'CN-SELECTRIC' ) {
								jQuery( function () {
									jQuery( element )
										.selectric();
								} )
							}
						}
					} )
				},
				post: function ( scope, element ) {
					scope.$watch( 'items', function ( v ) {
						if ( v ) {
							jQuery( function () {
								jQuery( element )
									.selectric( 'refresh' );
							} )
						}
					} )
				}
			}
		},
		controller: function ( $scope, $element, $attrs ) {}
	}
} );

portalapp.directive( 'scrollMe', function () {
	return {
		restrict: 'A',
		replace: true,
		controller: function ( $scope, $element, $attrs ) {},
		link: function ( scope, element, attrs ) {},
		compile: function () {
			return function ( scope, elem, attrs ) {
				var option = scope.$eval( attrs.scrollMe );
				$( elem )
					.slimScroll( {
						height: option.height,
						alwaysVisible: true
					} );
			}
		}
	}
} );

portalapp.directive( 'fileInput', [ '$parse', function ( $parse ) {
/*@ngInject*/
	return {
		restrict: 'A',
		link: function ( scope, elem, attrs ) {
			elem.bind( 'change', function () {
				if ( elem[ 0 ].files[ 0 ].size / ( 1024 * 1024 ) > ( 100 ) ) {
					scope.message = true;
					scope.fileSize = ( elem[ 0 ].files[ 0 ].size ) / ( 1024 * 1024 );
				} else {
					scope.message = false;
				}
				$parse( attrs.fileInput )
					.assign( scope, elem[ 0 ].files );
				scope.$apply();
                if (typeof jQuery !== 'undefined') {
                    var ele = jQuery(elem[0]);
                    var name = ele.attr('name');
                    if (jQuery('#' + name).length) {
                        jQuery('#' + name).val(elem[0].files[0].name);
                    }
                }
			} );
		}
	};
    } ] );


portalapp.factory( 'sharedModalService', function ( $rootScope ) {
	/*@ngInject*/
	var sharedService = {};
	sharedService.prepForModal = function ( modal ) {
		this.modal = modal;
		this.loadModal();
	}
	sharedService.loadModal = function () {
		$rootScope.$broadcast( 'editRecordModal' + this.modal + '.Template' );
	}
	sharedService.loadService = function ( service ) {
		$rootScope.$broadcast( 'service' + service );
	}
	return sharedService;
} )

portalapp.config(['$translateProvider', '$translatePartialLoaderProvider', function ($translateProvider, $translatePartialLoaderProvider) {
    
	// Default language loader.

    // $translateProvider.useLoader( '$translatePartialLoader', {
    // 	urlTemplate: 'i18n/{part}/{lang}.json'
    // } );
	
    //Custom language loader for angular-translate.

    $translateProvider.useLoader('customLanguageTemplateLoader', {});
	$translateProvider.preferredLanguage(document.documentElement.lang);
    $translateProvider.forceAsyncReload(true);
    $translateProvider.useSanitizeValueStrategy();
}]);

portalapp.factory('fetchLanguagePart', function ($q, $timeout) {
    /*@ngInject*/
    var languageService = {};
    languageService.languagePart = ['home', 'login'];

    languageService.getLanguagePart = function () {
        var url = purl();
        var part = url.param('module');
        if (part === undefined) {
            part = 'home';
        } else if (part === 'Portal') {
            part = 'login';
        } else if (part === 'PortalProfile') {
            part = 'Profile';
        }
        languageService.languagePart = part;
        return part;
    }
    return languageService;
})

portalapp.factory('customLanguageTemplateLoader', function ($q, $http, fetchLanguagePart, $timeout, $api) {
    /*@ngInject*/
    return function (options) {

        var getCustomLanguagePath = function (part) {
            return 'i18n/' + part + '/Custom/' + options.key + '.json';
        }
        var getFallBackLanguagePath = function (part) {
            return 'i18n/' + part + '/' + options.key + '.json';
        }
		var getDefaultLanguagePath = function() {
            return 'i18n/DefaultTranslations/' + options.key + '.json';
        }
        var fetchPartTranslations = function () {
            var deferred = $q.defer();
            var responses = {};
            var part = fetchLanguagePart.getLanguagePart();
            var customLanguageUrl = getCustomLanguagePath(part);
            var fallbackLanguageUrl = getFallBackLanguagePath(part);
            var defaultLanguagePathUrl = getDefaultLanguagePath();
            $api.getLanguageStrings('DefaultTranslations', [defaultLanguagePathUrl]).success(function(defaultTranslations) {
                if(typeof defaultTranslations === 'object') {
                    angular.extend(responses, defaultTranslations);
                }
                $api.getLanguageStrings(part, [fallbackLanguageUrl, customLanguageUrl]).success(function(moduleTranslations) {
                    if(typeof moduleTranslations === 'object') {
                        angular.extend(responses, moduleTranslations);
                    }
                    deferred.resolve(responses);
                });
            });
            
            return deferred.promise;
        }
        var deferred = $q.defer();
        var strings = {};
        var paths = [getFallBackLanguagePath('home'), getCustomLanguagePath('home')];
        $api.getLanguageStrings('home', paths).success(function(homeResult) {
            angular.extend(strings, homeResult);
            fetchPartTranslations().then(function (partTranslations) {
                angular.extend(strings, partTranslations);
                deferred.resolve(strings);
            });
        });
        
        return deferred.promise;
    }
})

portalapp.directive( 'cpPie', function ($timeout) {
	/*@ngInject*/
		return {
			restrict: 'E',
			replace: true,
			scope: {
				items: '=',
                seriesname: '=',
                seriesclickevent : '='
			},
			controller: function ( $scope, $element, $attrs ) {},
			template: '<div style="margin: 0 auto">not working</div>',
			link: function ( scope, element, attrs ) {
				$timeout(function(){
					$timeout(function(){
						var chart = new Highcharts.Chart( {
							chart: {
								renderTo: element[ 0 ],
								plotBackgroundColor: null,
								plotBorderWidth: null,
								plotShadow: false,
								height: 250
							},
							credits: {
								enabled: false
							},
							title: {
								useHTML: true,
								text: ''
							},
							tooltip: {
								pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>',
								percentageDecimals: 1,
								formatter: function () {
									var val = this.y,
										total = this.total,
										percentage = this.percentage;
									if ( !( ( val % 1 ) == 0 ) || !( ( total % 1 ) == 0 ) || !( ( percentage % 1 ) == 0 ) ) {
										val = Highcharts.numberFormat( val, 0 );
										total = Highcharts.numberFormat( total, 0 );
										percentage = Highcharts.numberFormat( this.percentage, 2 );
									}
									return '<b>' + this.point.name + '' + ' ' + '' + this.series.name + '</b><b>(' + val + '/' + total + ' = ' + percentage + '%)</b>';
								}
							},
							plotOptions: {
								pie: {
									allowPointSelect: true,
									animation: false,
									cursor: 'pointer',
									depth: 25,
									dataLabels: {
										enabled: false,
										formatter: function () {
											return '<b>' + this.point.name + '</b>: ' + Highcharts.numberFormat( this.percentage, 0 ) + ' %';
										},
										distance: 20,
									},
									showInLegend: true
								},
                                series: {
                                    cursor: 'pointer',
                                    point: {
                                        events: {
                                            click: function() {
                                                if(scope.seriesclickevent) {
                                                    scope.$emit(scope.seriesclickevent, this.options);
                                                }
                                            }
                                        }
                                    }
                                }
							},
							legend: {
								align: 'right',
								margin: 30,
								verticalAlign: 'middle',
								layout: 'vertical',
								width: 100,
								useHTML: true,
								itemMarginTop: 4,
								itemMarginBottom: 2,
								itemStyle: {
									padding: 3,
									width: 90,
									overflow: "hidden",
									textOverflow: "ellipsis",
									whiteSpace: "nowrap"
								},
							},
							series: [ {
								type: 'pie',
								name: scope.seriesname ? scope.seriesname : 'Tickets Share',
								data: scope.items
                            } ]
						} );
						scope.$watch( "items", function ( newValue ) {
							chart.series[ 0 ].setData( newValue, true );
						}, true );
					},0)
				},0);
			}
		}
	} )
	.directive( 'cpLine', function ($timeout) {
		/*@ngInject*/
		return {
			restrict: 'E',
			replace: true,
			scope: {
				items: '='
			},
			controller: function ( $scope, $element, $attrs ) {},
			template: '<div style="margin: 0 auto">not working</div>',
			link: function ( scope, element, attrs ) {
				$timeout(function(){
					$timeout(function(){
						var dataCategories = [];
						var values = [];
						angular.forEach( scope.items, function ( data, i ) {
							dataCategories[ i ] = data[ 0 ];
							values[ i ] = data[ 1 ];
						} );
						var chart = new Highcharts.Chart( {
							chart: {
								renderTo: element[ 0 ],
								height: 250
							},
							credits: {
								enabled: false
							},
							title: {
								enabled: false,
								useHTML: true,
								text: ''
							},
							xAxis: {
								categories: dataCategories,
								labels: {
									enabled: false
								}
							},
							yAxis: {
								min: 0,
								title: {
									text: 'Days'
								}
							},
							legend: {
								enabled: false,
							},
							tooltip: {
								enabled: true,
								formatter: function () {
									return '<b>' + this.x + '</b><br/>' +
										this.series.name + ': ' + this.y + ' Days';
								}
							},
							series: [ {
								name: 'Closure time',
								type: 'spline',
								data: values
																} ]
						} );
					},0)
				},0)
			}
		}
	} );


portalapp.run( function ( $rootScope, $translate, editableOptions ) {
	$rootScope.$on( '$translatePartialLoaderStructureChanged', function () {
		$translate.refresh();
	} );
	editableOptions.theme = 'bs3';
} );

portalapp.directive( 'portalDate', function ( dateFilter, $parse ) {
	/*@ngInject*/
	return {
		restrict: 'EAC',
		require: '?ngModel',
		link: function ( scope, element, attrs, ngModel, ctrl ) {
			ngModel.$parsers.push( function ( viewValue ) {
				return dateFilter( viewValue, 'yyyy-MM-dd' );
			} );
		}
	}
} );

portalapp.directive( "autofill", function () {
	return {
		require: "ngModel",
		link: function ( scope, element, attrs, ngModel ) {
			scope.$on( "autofill:update", function () {
				ngModel.$setViewValue( element.val() );
			} );
		}
	}
} );

portalapp.filter( 'propsFilter', function () {
	return function ( items, props ) {
		var out = [];

		if ( angular.isArray( items ) ) {
			items.forEach( function ( item ) {
				var itemMatches = false;

				var keys = Object.keys( props );
				for ( var i = 0; i < keys.length; i++ ) {
					var prop = keys[ i ];
					var text = props[ prop ].toLowerCase();
					if ( item[ prop ].toString()
						.toLowerCase()
						.indexOf( text ) !== -1 ) {
						itemMatches = true;
						break;
					}
				}

				if ( itemMatches ) {
					out.push( item );
				}
			} );
		} else {
			// Let the output be the input untouched
			out = items;
		}

		return out;
	};
} );

portalapp.factory('jstz',function($window){
  return {
    getTimeZone:function(){
      var jstz = $window.jstz;
      var timeZone = jstz.determine().name();
      return timeZone;
    }
  }
})

portalapp.factory('downloadAttachment',function($q,$window,$http,$webapp){
	/*@ngInject*/

	return function(params){
		var baseUrl = 'index.php?';
		var defaultParams = {'api':'DownloadFile'};
		var finalParameters = angular.extend(defaultParams,params);
		$http.get(baseUrl,{'params':finalParameters}).then(function(data){
			try	{
				var result = data.data.result;
				$webapp.busy(false);
				var linkElement = document.createElement('a');
				var byteString = atob(result['filecontents']);
				var arrayBuffer = new ArrayBuffer(byteString.length);
				var charArray = new Uint8Array(arrayBuffer);
				for (var i=0;i<byteString.length;i++){
					charArray[i] = byteString.charCodeAt(i);
				}
				var blob = new Blob([charArray], {type: result['content-type']});
                //#PT72549::Unable to download document in IE: IE10+ has Blob, but not a[download] or URL
                // ref:- 1) https://stackoverflow.com/questions/25121384/ie-download-file , and
                //       2) https://stackoverflow.com/questions/18394871/download-attribute-on-a-tag-not-working-in-ie
                if (navigator.msSaveBlob) {
                    return navigator.msSaveBlob(blob, result['filename']);
                } else {
                    var fileUrl = window.URL.createObjectURL(blob);
                    linkElement.setAttribute('href', fileUrl);
                    linkElement.setAttribute('download', result['filename']);
                    var clickEvent = document.createEvent("MouseEvents");
                    clickEvent.initMouseEvent("click", true, false, window, 0, 0, 0, 80, 20, false, false, false, false, 0, null);
                    linkElement.dispatchEvent(clickEvent);
                }
            } catch(ex){
				console.error(ex);
			}
		}).catch(function(data){

		}).finally(function(data){

		})
	}
});

portalapp.filter('dateFormat', function($sce) {
	return function(val) {
		if(val.trim()) {
			var dateFormat = document.documentElement.getAttribute('date-format');
			var dateParts = val.split('-');
			if(dateFormat == 'dd-mm-yyyy') {
				return dateParts[2] + '-' + dateParts[1] + '-' + dateParts[0];
			} else if(dateFormat == 'mm-dd-yyyy') {
				return dateParts[1] + '-' + dateParts[2] + '-' + dateParts[0];
			} else {
				return val;
			}
		}
		return '';
	};
});

portalapp.filter('dateTimeFormat', function($sce) {
	return function(val) {
		if(val.trim()) {
			var dateTimeFormat = getDateTimeFormat();
			return moment(val).format(dateTimeFormat);
		}
		return '';
	};
});