<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

abstract class Vtiger_Connector {

    protected function __construct() {

    }

    abstract public function isAuthenticated();

    abstract public function authentication();

    abstract public function ping($username, $password);

    abstract public function describeModule($module, $language);

    abstract public function fetchModules($username, $password, $language);

    abstract public function fetchRecords($module, $label, $q, $filter, $pageNo, $pageLimit, $orderBy, $order);

    abstract public function fetchRecord($id, $parentId = '', $module);

    abstract public function fetchRelatedRecords($id, $relatedModule, $relatedModuleLabel, $parentId, $pageNo, $pageLimit, $module);

    abstract public function saveRecord($module, $record);

    abstract public function fetchHistory($module, $id, $pageNo, $pageLimit, $parentId);

    abstract public function downloadFile($module, $id, $parentId, $parentModule,$attachmentId);

    abstract public function changePassword($record);

    abstract public function uploadAttachment($module, $parentId);

    abstract public function forgotPassword($email);

    abstract public function fetchRelatedModules($module);

    abstract public function fetchAnnouncement();

    abstract public function fetchShortcuts();

    abstract public function fetchRecentRecords($language);

    abstract public function fetchSupportNotification();

    abstract public function fetchCharts($language);

    abstract public function fetchReferenceRecords($module, $query);

    abstract public function fetchCompanyDetails();

    abstract public function exportRecords($module, $label, $q, $filter);

    abstract public function searchFaqs($module, $searchKey);

    abstract public function searchRecords($searchKey);
    
    abstract public function trackEngagement($status);
    
    abstract public function fetchFaqCategoryCounts();
    
    abstract public function fetchCustomThemeUrl();
	
	abstract public function fetchDefaultScopeFilter();
	
	abstract public function fetchGreetingType();
	
	abstract public function fetchAccountRepresentatives();
    
    public static function getInstance() {
        static $singleton = null;
        if ($singleton === null) {
            $singleton = new Vtiger_Portal_Connector();
        }

        return $singleton;
    }
}
