<?php
/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/
define('KB', 1024);
define('MB', 1048576);
define('GB', 1073741824);
define('TB', 1099511627776);

class Portal_MultiUploadAttachment_API extends Portal_Default_API {

    static $fileUploadLimit = 5;

    public function process(Portal_Request $request) {
        set_time_limit(0);
        ini_set('memory_limit', '1024M');
        $maxUploadSize = Portal_Config::get('upload_max_filesize');
        $module = $request->getModule();
        $parentId = $request->getParentId();
        $titles = array();
        if ($request->has('titles')) {
            $titles = $request->get('titles');
        }
        $tmp_files = $_FILES['file'];
        $files = array();
        $fileNames = $_FILES['file']['name'];
        $noOfFiles = count($fileNames);
        if ($noOfFiles > self::$fileUploadLimit) {
            $response = new Portal_Response();
            $response->setError("Files limit exceeded");
            return $response;
        }
        $totalSize = 0;
        for ($i = 0; $i < $noOfFiles; $i++) {
            $totalSize += $_FILES['file']['size'][$i];
            $files[$i] = array(
                'name'     =>  $_FILES['file']['name'][$i],
                'type'     =>  $_FILES['file']['type'][$i],
                'tmp_name' =>  $_FILES['file']['tmp_name'][$i],
                'error'    =>  $_FILES['file']['error'][$i],
                'size'     =>  $_FILES['file']['size'][$i],
            );
        }
        if ($totalSize > $maxUploadSize * MB) {
            unset($_FILES['file']);
            $response = new Portal_Response();
            $response->setError("Filesize larger than $maxUploadSize");
            return $response;
        }
        $result = array('records' => array());
        foreach ($files as $index => $details) {
            if ($titles[$index]) $details['title'] = $titles[$index];
            $_FILES['file'] = $details;
            $fileResponse = Vtiger_Connector::getInstance()->uploadAttachment($module, $parentId);
            if ($fileResponse['record']) $result['records'][] = $fileResponse['record'];
        }
        $_FILES['file'] = $tmp_files;
        $response = new Portal_Response();
        $response->setResult($result);
        return $response;
    }
}
