<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_Login_API extends Portal_Default_API {

    public function requireLogin() {
        return false;
    }

    public function preProcess(Portal_Request $request) {

    }

    public function postProcess(Portal_Request $request) {

    }

    public function process(Portal_Request $request) {
        $params = $request->get('q');
        $response = new Portal_Response();
        $loginStatus = array();
        
        $data = array('username'=>$params['username'],'action'=>'hasUserReachedLoginAttemptsThreshold');
        $loginAttemptsThresholdResponse = Vtiger_Connector::getInstance()->loginFailure($data);  
        if (isset($loginAttemptsThresholdResponse['message']) && !strcmp($loginAttemptsThresholdResponse['message'], "You have reached max login attempts. Please contact your CRM administrator.")) {
            $loginStatus['success'] = false;
            $loginStatus['error']['message'] = 'You have reached max login attempts. Please contact your CRM administrator.';
            $response->setResult($loginStatus);
            return $response;
        }  
        
        $result = Vtiger_Connector::getInstance()->ping(
            $params['username'], $params['password']
        );
        
        if (isset($result['message']) && !strcmp($result['message'], "Login failed")) {
            $loginStatus['success'] = false;
            $loginStatus['error']['message'] = 'The email & password you entered is incorrect or Portal access has not been enabled for this account';
            $response->setResult($loginStatus);
        }else if (isset($result['message']) && strpos($result['message'], "Your access to portal is not enabled yet. Access to support starts on") !== false) {
            $loginStatus['success'] = false;
            $loginStatus['error']['message'] = $result['message'];
            $response->setResult($loginStatus);
        } else if(empty($result)){
            $loginStatus['success'] = false;
            $loginStatus['error']['message'] = 'Cannot connect to Server.Please configure your site url in provided config file.';
            $response->setResult($loginStatus);
        }else {
            Vtiger_Connector::getInstance()->fetchModules($params['username'], $params['password']);
            Vtiger_Connector::getInstance()->trackEngagement("Login");
            $data = array('username'=>$params['username'],'action'=>'trash');
            Vtiger_Connector::getInstance()->loginFailure($data);
            $loginStatus['success'] = true;
            $loginStatus['result'] = 'Login Success';
            $response->setResult($loginStatus);
        }
        
        if(!$loginStatus['success']){
            $data = array('username'=>$params['username'],'action'=>'track');
            Vtiger_Connector::getInstance()->loginFailure($data);
        }
        
        return $response;
    }

}
