<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

require_once 'include/utils/utils.php';

class Portal_FetchHistory_API extends Portal_Default_API {

    public function process(Portal_Request $request) {
        $module = $request->getModule();
        $pageNo = $request->get('page');
        $language = $request->getLanguage();
        $pageLimit = $request->get('pageLimit');
        $parentId = $request->get('parentId');
		$selectedMode = $request->get('selectedMode');
        if ($parentId !== '') {
            $parent = $parentId;
        }
        if (empty($pageNo)) {
            $pageNo = 0;
        }
        if (empty($pageLimit)) {
            $pageLimit = 10;
        }
        $rollupTo = $request->get('roll_up_to');
        $result = Vtiger_Connector::getInstance()->fetchHistory($module, $request->get('id'), $pageNo, $pageLimit, $parent, $selectedMode, $rollupTo);
        $response = new Portal_Response();
        $response->setResult($this->processResponse($result, $module, $language));

        return $response;
    }
    
    protected static $meta_cache = [];
    public function processResponse($result, $module,$language) {
        if (!empty($result['history'])) {
            $history = array();
            foreach ($result['history'] as $key => $valueArray) {
                if(!static::$meta_cache[$valueArray['module']]) {
                    static::$meta_cache[$valueArray['module']] = parent::processResponse($valueArray['module'], $language);
                }
                $recordMeta = static::$meta_cache[$valueArray['module']];
                $status = $valueArray['status'];
                if ($valueArray['values']) {
                    $new = array();
                    $new['_id'] = $valueArray['id'];
                    $new['_module'] = $valueArray['module'];
                    $new['_label'] = $valueArray['label'];
                    $new['_type'] = $status;
                    $new['modifiedtime'] = $valueArray['modifiedtime'];
                    foreach ($valueArray['values'] as $fieldname => $values) {
                        if ($recordMeta[$fieldname]['type'] == 'picklist' || $recordMeta[$fieldname]['type'] == 'metricpicklist' || $recordMeta[$fieldname]['type'] == 'radio') {
                            foreach ($recordMeta[$fieldname]['picklistValues'] as $labelValue => $label) {
                                if (!empty($values['previous']) && $values['previous'] == $label['value']) {
                                    $values['previous'] = $label['label'];
                                }
                                if (!empty($values['current']) && $values['current'] == $label['value']) {
                                    $values['current'] = $label['label'];
                                }
                            }
                        }
                        if ($recordMeta[$fieldname]['type'] == 'multipicklist') {
                            if (!empty($values['previous'])) {
                                $values['previous'] = str_replace(' |##| ', ',', $values['previous']);
                            }
                            if ($values['previous'] == 0) {
                                $values['previous'] = '';
                            }
                            if (!empty($values['current'])) {
                                $values['current'] = str_replace(' |##| ', ',', $values['current']);
                            }
                        }
						if($recordMeta[$fieldname]['type'] == 'date' || $recordMeta[$fieldname]['type'] == 'anniversary') {
							$values['previous'] = getDisplayDate($values['previous']);
							$values['current'] = getDisplayDate($values['current']);
						}
						if($recordMeta[$fieldname]['type'] == 'datetime') {
							$values['previous'] = getDisplayDateTime($values['previous']);
							$values['current'] = getDisplayDateTime($values['current']);
						}
                        if ($recordMeta[$fieldname]['type'] == 'text' || $recordMeta[$fieldname]['type'] == 'string') {
                            if (!empty($values['previous'])) {
                                if ($values['previous'] === 0) {
                                    $values['previous'] = '';
                                }
                            }
                        }

                        if ($recordMeta[$fieldname]['type'] == 'date') {
                            if ($values['current'] == '') {
                                $values['previous'] = '';
                            }
                        }

                        if ($recordMeta[$fieldname]['type'] == 'url') {
                            if (!empty($values['previous'])) {
                                if ($values['previous'] == 0) {
                                    $values['previous'] = '';
                                }
                            }
                        }

                        if ($recordMeta[$fieldname]['type'] == 'time') {
                            if ($values['current'] == '') {
                                $values['previous'] = '';
                            }
                        }

                        if ($recordMeta[$fieldname]['type'] == 'phone') {
                            if ($values['current'] == '') {
                                $values['previous'] = '';
                            }
                        }

                        if ($recordMeta[$fieldname]['type'] == 'email') {
                            if (!empty($values['previous'])) {
                                if ($values['previous'] == 0) {
                                    $values['previous'] = '';
                                }
                            }
                        }

                        if ($recordMeta[$fieldname]['type'] == 'double' || $recordMeta[$fieldname]['type'] == 'currency' || $recordMeta[$fieldname]['type'] == 'multicurrency') {
                            if (!empty($values['previous'])) {
                                $values['previous'] = round($values['previous'], 2);
                            }
                            if (!empty($values['current'])) {
                                $values['current'] = round($values['current'], 2);
                            }
                        }
                        if ($recordMeta[$fieldname]['type'] == 'boolean') {
                            if ($values['previous'] !== '') {
                                $values['previous'] = $values['previous'] == 0 ? 'No' : 'Yes';
                            }
                            if ($values['current'] !== '') {
                                $values['current'] = $values['current'] == 1 ? 'Yes' : 'No';
                            }
                        }
                        
                        if($recordMeta[$fieldname]['type'] == 'estimate') {
                            if ($values['previous'] !== '') {
                                $values['previous'] = humanizeEstimate($values['previous']);
                            }
                            if ($values['current'] !== '') {
                                $values['current'] = humanizeEstimate($values['current']);
                            }
                        }

                        if ($recordMeta[$fieldname]['type'] == 'reference') {
                            if ($values['previous'] !== '') {
                                if ($values['previous'] == 0) {
                                    $values['previous'] = '';
                                } else {
                                    $values['previous'] = $values['previous'];
                                }
                            }
                            if ($values['current'] !== '') {
                                $values['current'] = $values['current'];
                            }
                        }
                        
                        if ($recordMeta[$fieldname]['type'] == 'ownergroup' || $recordMeta[$fieldname]['type'] == 'owner'){
                            if (empty($values['previous']) && $values['previous'] === "0"){
                                $values['previous'] = '';
                            }
                            if (empty($value['current']) && $values['current'] === "0"){
                                $values['current'] = '';
                            }
                        }

                        if ($recordMeta[$fieldname]['type'] == 'text') {
                            $values['previous'] = str_replace("\n", '', $values['previous']);
                            $values['current'] = str_replace("\n", '', $values['current']);
                            $values['previous'] = preg_replace('/<br(\s+)?\/?>/i', "\n", $values['previous']);
                            $values['current'] = preg_replace('/<br(\s+)?\/?>/i', "\n", $values['current']);
                            $values['previous'] = strip_tags($values['previous']);
                            $values['current'] = strip_tags($values['current']);
                        }
                        
                        if ($recordMeta[$fieldname]['type'] == 'datetime' && $values['current']=='0000-00-00 00:00:00' && $module == 'Cases'){
                            unset($values);
                        }


                        $fieldname = $recordMeta[$fieldname]['label'];
                        if(is_array($values)){
	                        foreach ($values as $k => $val) {
	                            if ($status == 'updated') {
	                                $createCount = count($valueArray['values']);
	                                $new[$fieldname]['updateStatus'] = $status;
	                                $new[$fieldname][$k] = html_entity_decode((html_entity_decode($values[$k], ENT_QUOTES, 'utf-8')));
                                    $new['updated']['user'] = $valueArray['modifieduser']['label'];
	                            } elseif ($status == 'created') {
	                                $new['id']['updateStatus'] = $status;
	                                $updateCount = count($valueArray['values']);
	                                $new['created']['user'] = $valueArray['modifieduser']['label'];
	                                break;
	                            }
	                        }
	                    }
                    }
                }
                $history['records'][] = $new;
            }
        }
        $history['count'] = count($history['records']);
        return $history;
    }
}
