<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_ExportRecords_API extends Portal_FetchRecords_API {

    public function process(Portal_Request $request) {
        $module = $request->getModule();
        $language  = Portal_Session::get('language');
        $params = $request->get('q');
        $filter = $request->get('filter');
        $timeZone = $request->get('browserTimeZone');
        if (!empty($filter)) {
            $params['fields'] = json_encode($filter);
        }
        $result = Vtiger_Connector::getInstance()->exportRecords($module, $request->get('label'), $request->get('q', array()), $params['fields']);
        $parsedResult = $this->parseListViewRecords($result,$module,$timeZone);
        $response = new Portal_Response();
        $response->setResult($this->processResponse($parsedResult, $module,$language,true));
        return $response;
    }

    public function parseListViewRecords($response,$module,$timeZone){
      $edit = $headers = $records = array();
      for ($i = 0; $i < count($response); $i++) {
          if ($response[$i]) {
              $record = array();
              if (!is_array($response[$i]))
                  continue;
              foreach ($response[$i] as $field => $value) {
                  if ($i == 0) {
                      $headers[] = $field;
                      $edit[$field] = $field;
                  }
                  if (is_array($value)) {
                      $record[$field] = $value['label'];
                  } else {
                      $record[$field] = $value;
                  }
              }
              $record['Timezone'] = $timeZone;
          }
          $records[] = $record;
      }
      $headers[] = 'Timezone';
      $edit[] = 'Timezone';
      return array('headers' => $headers, 'records' => $records, 'edit' => $edit);
  }



}
