/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

portalapp.controller("MainController",function($scope, $api, $webapp, $modal, $translate, $translatePartialLoader,$rootScope, $deferred) {

    /*@ngInject*/

    $translatePartialLoader.addPart('login');
    $translatePartialLoader.addPart('home');
    $scope.loginUser = null;
    $scope.modules = [];
    if($scope.languages === undefined || $scope.defaultLanguage === undefined){
        $scope.getLanguages = function() {
        $api.get('Portal/FetchAvailableLanguages').success(function(response){
                $scope.languages = response.availableLanguages;
                $scope.language = response.defaultLanguage.value;
                $translate.use($scope.language);
            })
        }
    }
    
    if(localStorage.getItem('themeurl') === null || localStorage.getItem('themeurl') === "null" || localStorage.getItem('themeurl') === undefined || typeof localStorage.getItem('themeurl') === "undefined"){
        $api.get('Portal/FetchCustomThemeUrl').success(function(response){
            $scope.themeurl = response.themeurl;
            localStorage.setItem('themeurl',$scope.themeurl);
        })
    }else{
        $scope.themeurl = localStorage.getItem('themeurl');
    }
    
    //translate-cloak resolution.
    $translate.use(document.documentElement.lang);
    $api.get('Portal/Ping').success(function(user) {
        if (user) {
            $scope.loginUser = true;
            $translate.use(user.language);
            $scope.language = user.language;
            if (localStorage.getItem('modules') !== null) {
                $scope.modules = JSON.parse(localStorage.getItem('modules'));
                $scope.updateModuleSize();
                if(localStorage.getItem('orgName')==undefined)$scope.companyDetails();
                $scope.$root.$emit('LoginUser.Ready');
            }
            else {
                $scope.fecthModules($scope.language, function(){
                    $scope.$root.$emit('LoginUser.Ready');
                });
            }
        }
    });
    
    //Function to get the count of the dashbord modules
    $scope.updateModuleSize = function() {
        var modulesCount = Object.keys($scope.modules).length;
            const items = ['ProjectTask', 'ProjectMilestone','language'];
            for (let i=0; i<items.length; i++) {
                     if($scope.modules[items[i]])  modulesCount = modulesCount -1;
            }
            $scope.moduleSize=modulesCount;
    };

    $scope.fecthModules = function(language, next) {

        $api.get('/FetchModules',{language:language}).success(function(result) {
            
            delete(result.language);
            $scope.modules = result.moduleInfo;
            $scope.updateModuleSize();
            $scope.profileModules = result.profileModulesInfo;
            
            localStorage.setItem('modules', JSON.stringify($scope.modules));
			localStorage.setItem('profileModules', JSON.stringify($scope.profileModules));
            if (result.endDate !== undefined){
                localStorage.setItem('supportNotification', result.endDate);
            }
            if (result.maxUploadFileSize !== undefined){
                localStorage.setItem('maxUploadFileSize',result.maxUploadFileSize);
            }
            if(next) return next();
        });
    }
    
    $scope.fetchRecord = function(module, id, params) {
        var localScope = params.scope;
        var isUpdate = params.isUpdate;
        var deferred = $deferred.create();
        $api.get( module + '/FetchRecord', {
				id: id,
				parentId: localScope.parentId,
				language: $scope.language,
				selectedMode: localScope.selectedMode
        }).success(function(result) {
            if (!isUpdate) {
                $webapp.busy(false);
            }
            if ( result.record === undefined && result.message !== undefined ) {
                if(params.fromRelatedList) { // This is set in Portal_RelatedEditView_Component
                    deferred.resolve({error: true, message : result.message});
                    return true;
                }
                
                if ( result.message === 'Record not Accessible' ) {
                    alert( "Record is not accessible." );
                    var moduleLabel = localScope.module;
                    if ( localScope.module === 'ProjectTask' || localScope.module === 'ProjectMilestone' ) {
                        moduleLabel = 'Project'
                    }
                        window.location.href = "index.php?module=" + moduleLabel;
                } else if ( result.message === 'Contacts module is disabled' ) {
                    alert( "Contacts module has been disabled." )
                    window.location.href = "index.php?view=Logout";
                }
            }
            localScope.pageInitialized = true;
            localScope.isWaitingForApproval = result.isWaitingForApproval;
            localScope.isLocked = result.isLocked;
            if(result.record.identifierName) {
                localScope.header = result.record.identifierName.label;
            }
            localScope.record = result.record;
            localScope.edits = result.editLabels;
            localScope.rteFields = result.rteFields;
            localScope.documentExists = true;
            if ( result[ localScope.module ] !== undefined ) {
                localScope.record.referenceFields = result[ localScope.module ].referenceFields;
                localScope.record.multiCurrencySymbol = jQuery('<div></div>').html(result[ localScope.module ].multiCurrencySymbol).text();
                localScope.record.dateTimeFields = result[localScope.module].dateTimeFields;
				localScope.record.dateFields = result[localScope.module].dateFields;
            }
            if ( localScope.module === 'HelpDesk' ) {
                localScope.HelpDeskStatus = result.HelpDesk.status;
                localScope.HelpDeskCloseLabel = result.HelpDesk.closeLabel;
                localScope.HelpDeskIsStatusEditable = result.HelpDesk.isStatusEditable;
                if ( result.HelpDesk.referenceFields !== undefined )
                    localScope.record.referenceFields = result.HelpDesk.referenceFields;
            }
            if ( localScope.module === 'Cases' ) {
                localScope.CasesStatus = result.Cases.status;
                if(localScope.CasesStatus.toUpperCase() !== 'CLOSED' && !localScope.isWaitingForApproval){
                    localScope.isCommentCreateable = true;
                }
                localScope.CasesCloseLabel = result.Cases.closeLabel;
                localScope.CasesResolveLabel = result.Cases.resolveLabel;
                localScope.CasesOpenLabel = result.Cases.openLabel;
                localScope.CasesIsStatusEditable = result.Cases.isStatusEditable;
                localScope.CasesMarkCaseOpen = result.Cases.markopen;
                if ( result.Cases.referenceFields !== undefined )
                    localScope.record.referenceFields = result.Cases.referenceFields;
            }
            //Adding quote accept ability
            if ( localScope.module === 'Quotes' ) {
                localScope.quoteStage = result.Quotes.stage;
                localScope.quoteAcceptLabel = result.Quotes.acceptLabel;
                localScope.$watch( 'quoteStage', function ( nvalue, ovalue ) {
                    localScope.quoteAccepted = false;
                    if ( nvalue != ovalue ) {
                        if ( nvalue.toUpperCase() != 'ACCEPTED' ) {
                            localScope.quoteAccepted = true;
                        }
                    } else if ( ovalue.toUpperCase() != 'ACCEPTED' ) {
                        localScope.quoteAccepted = true;
                    }
                } );
            }
            if ( localScope.module === 'Documents' ) {
                localScope.documentExists = result.record.documentExists;
            }
            deferred.resolve(true, null);
        });
        return deferred.promise;
    }

    $scope.moduleFromObj = Object.keys($scope.modules).map(function(key){
      return $scope.modules[key];
    })
    
    $scope.isDetailViewRowAllowed = function(fieldname) {
        var header = $scope.header;
        return angular.equals(fieldname, "id") || angular.equals(fieldname, "identifierName") || angular.equals(fieldname, header) || angular.equals(fieldname,"documentExists") ||  angular.equals(fieldname,"referenceFields") || angular.equals(fieldname,"multiCurrencySymbol") || angular.equals(fieldname,"dateTimeFields") || angular.equals(fieldname,"dateFields") || angular.equals(fieldname, "filename") || angular.equals(fieldname, "file_url") || angular.equals(fieldname, "filetype") || angular.equals(fieldname, "isclosed");
    };

    $scope.notSorted = function(obj){
        if (!obj) {
            return [];
        }
        return Object.keys(obj);
    }

    $scope.changePassword = function() {
        var modalInstance = $modal.open({
            templateUrl: 'changePassword.template',
            controller: 'Main_Setting_Component',
            backdrop:'static',
            keyboard: 'false',
            resolve: {
                record: function() {
                    return {};
                },
                api: function() {
                    return $api;
                },
                webapp: function() {
                    return $webapp;
                },
                module: function() {
                    return $scope.module;
                },
                translatePartialLoader:function(){
                  return $translatePartialLoader;
                }
            }
        });
    }
	
    $scope.forgotPassword = function() {
        var modalInstance = $modal.open({
            templateUrl: 'forgotPassword.template',
            controller: 'ForgotPassword_Component',
            backdrop:'static',
            keyboard: 'false',
            resolve: {
                api: function() {
                    return $api;
                },
                webapp: function() {
                    return $webapp;
                },
                translatePartialLoader:function(){
                  return $translatePartialLoader;
                }
            }
        });
    };

    $scope.setLanguage = function(lang) {
        document.documentElement.setAttribute('lang',lang);
        $translate.use(lang);
    };
    $scope.logout = function() {
        localStorage.clear();
        window.location.href = "index.php?module=Portal&view=Logout";
    }
    $scope.isActive = function(module) {
        var url = purl();
        var routeModule = url.param('module');
        if (routeModule !== undefined) {
            if (module === routeModule) {
                return true;
            }
            else {
                return false;
            }
        }
        if (module == 'Home' && routeModule === undefined) {
            return true;
        }
    }
    $scope.companyDetails = function() {
        $api.getCompanyDetails().success(function(data) {
            if(data.message===undefined && data.code===undefined)
                $scope.companyInfo = angular.copy(data);
            else if(data.message==='Contacts module is disabled'){
              alert(data.message);
              localStorage.clear();
              window.location.href = 'index.php?module=Portal&view=Logout';
            }
        })
    }
    $scope.disableSearch = true;
    $scope.Query = {};
    $scope.searchEvent = function(Query) {
        $scope.$broadcast('searchFor', $scope.Query.search);
    }

    $scope.makeAutoComplete=function(){
      $scope.$broadcast("autofill:update");
    }

    $scope.login = function(validity) {
        q = {};
        q.username = $scope.username;
        q.password = $scope.password;
        q.language = $scope.language;
        if(validity){
        $scope.noUserName=false;
        $scope.noPassword=false;
        $api.post('Portal/Login', {q: q}).success(function(response) {
            if (response.success) {
                // When trying to access mention record URL by the portal user, 
                // if the portal user in the logged out state after logged in 
                // we have to redirect to previously access URL. 
                var redirectUrl = localStorage.getItem("__p_redirect_to");
                redirectUrl = redirectUrl ? redirectUrl : 'index.php';
                window.location.href = redirectUrl;
            }
            else {
                $scope.loginFailed = true;
                $scope.loginMessage = response.error.message;
            }
        });
      }
      else if(!validity){
        if(q.username===undefined && q.password===undefined){
          $scope.noUserName=true;
          $scope.loginFailed=false;
          return false;
        }
        if(q.password!==undefined && q.username===undefined){
          $scope.noUserName=true;
          $scope.noPassword=false;
          $scope.loginFailed=false;
          return false;
        }
        if(q.username!==undefined && q.password===undefined){
          $scope.noPassword=true;
          $scope.noUserName=false;
          $scope.loginFailed=false;
          return false;
        }
      }
    }
    $scope.openLink = function ($event) { 
        if($event.target.tagName.toLowerCase() == 'a'){ 
            window.open($event.target.href);
        }
    }
  $api.getCompanyTitle().then(function(err,data){
    if (err){
      //Error fetching company title.
      $scope.companyTitle ='';
    }
    if(data){
      $scope.companyTitle = data.result;
    }
  })
  
});

portalapp.controller("Main_Setting_Component",function($scope, $modalInstance, record, api, $webapp, module,translatePartialLoader) {
    /*@ngInject*/
    if(translatePartialLoader!==undefined){
      translatePartialLoader.addPart('home');
    }
    $scope.editRecord = angular.copy(record);
    $scope.data = {'oldPassword': "", 'newPassword': "", 'confirmPassword': ""};
    $scope.save = function() {
        api.post('Portal/ChangePassword', {record: $scope.data}).success(function(result) {
            $modalInstance.dismiss();
            if(result.result.message===undefined){
            alert(result.result);
            $webapp.busy(false);
            localStorage.clear();
            window.location.href = 'index.php?module=Portal&view=Logout';
          }
          else if(result.result.message!==undefined){
            alert(result.result.message)
            $webapp.busy(false);
          }
        });
    }

    $scope.cancel = function() {
        $modalInstance.dismiss('cancel');
    }
});

portalapp.controller("ForgotPassword_Component",function($scope, $modalInstance, api, $webapp,translatePartialLoader) {
  /*@ngInject*/
  if(translatePartialLoader!==undefined){
    translatePartialLoader.addPart('home');
  }
    $scope.data = {'email': ""};
    $scope.updatePassword = function() {
        $webapp.busy(true);
        api.post('Portal/ForgotPassword', {email: $scope.data.email}).success(function(data) {
            $modalInstance.dismiss();
            if(data.result.message===undefined){
            alert(data.result);
          }
          else if(data.result.message!==undefined){
            alert(data.result.message);
          }
            $webapp.busy(false);
        });
    };

    $scope.cancel=function(){
      $modalInstance.dismiss('cancel');
    }
});

portalapp.controller("globalSearchController",function($scope,$http,$timeout,$webapp,$translate,$q,$filter){
  /*@ngInject*/
  jQuery(".search-icon").on('click',function(e){
    jQuery(".search-box").focus();
  })

  $scope.search = '';

  $scope.getModuleLabelClass = function(module){
    return 'label label-info';
  }

  $scope.searchItemSelected = function (item,$timeout){
    if (item.model.count>0){
    var module = item.model.module.module;
    var url = "index.php?module="+module+"&view=Detail&id="+item.model.id;
    window.location.href = url;
  }
  else {
    $scope.search = '';
    return false;
  }
}

  $scope.searchRecords = function (searchKey,$timeout){
    var params = {
      "api":"SearchRecords",
      "searchKey":searchKey,
      "module":"Portal"
    };
    return $http.get("index.php",{params:params}).then(function(response){
      $webapp.busy();
      var result = [];
      var data = response.data.result;
      angular.forEach(data,function(moduleInfo,i){
        if (angular.isObject(moduleInfo) && moduleInfo.length!==0){
          if (i!=='language'){
          var labelField = 'label';
          angular.forEach(moduleInfo,function(recordInfo) {
            if (recordInfo.hasOwnProperty('id')){
              var res = {value:recordInfo[labelField],module:{"module":i,"uiLabel":moduleInfo.uiLabel},id:recordInfo.id,count:1};
              result.push(res);
            }
          });
        }
        }
      });
      if (result.length<1){
        //No results found
        $scope.noMatchFound = true;
        var noRecords = {value:$translate.instant('No matches found.'),module:{},count:0};
        result.push(noRecords);
      }
       $webapp.busy(false);
      return result;
    });
  }
});
