/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/
portalapp.controller("Project_DetailView_Component",function($scope, $api, $webapp, $translatePartialLoader,sharedModalService,$modal,$controller, $cache) {
    /*@ngInject*/
    if ($translatePartialLoader !== undefined) {
        $translatePartialLoader.addPart('home');
        $translatePartialLoader.addPart('Project');
        $translatePartialLoader.addPart('Documents');
        $translatePartialLoader.addPart('ProjectTask');
        $translatePartialLoader.addPart('ProjectMilestone');
    }
    $controller("Portal_DetailView_Component",({$scope:$scope}));
    var url = purl();

    $scope.module = url.param('module');
    $scope.id = url.param('id');
    $scope.pageInitialized = false;
    $scope.splitContentView = false;
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();

    $scope.record = null;
    $scope.fields = [];

    $scope.isEditable = false;
    $scope.isCommentsEnabled = true;
    $scope.isCommentCreateable = true;
    $scope.summaryEnabled = true;

    $scope.comments = [];
    $scope.newcomment = {};

    $scope.updates = [];

    $scope.$on('editRecordModalDocuments.Template', function() {
      $modal.open({
        templateUrl: 'editRecordModalDocuments.template',
        controller: 'Documents_EditView_Component',
        backdrop:'static',
        keyboard:'false',
        resolve: {
          record: function() {
            return {'parentId':$scope.id,'parentModule':$scope.module};
          },
          api: function() {
            return $api;
          },
          webapp: function() {
            return $webapp;
          },
          module: function() {
            return 'Documents';
          }
        }
      });
    });

    $scope.attachDocument = function(module, action) {
      var actionConfig = {'LBL_ADD_DOCUMENT': 'Documents'};
      if (actionConfig.hasOwnProperty(action)) {
        sharedModalService.prepForModal(actionConfig[action]);
      }
    }
    
    $scope.loadTasks = function(pageNo) {
        $scope.isTasksFilterEnabled = true;
        if (pageNo === undefined) {
            $scope.tasksPageNo = 1;
        } else {
            $scope.tasksPageNo = pageNo;
        }
        var params = {
            'relatedModule': 'Calendar',
            'id': $scope.id,
            'relatedModuleLabel': 'Tasks',
            'page': $scope.tasksPageNo
        }

        var filterCacheKey= 'Project_Calendar_filter_fields';
        var filter = $cache.get(filterCacheKey);
        if(filter && typeof filter == 'object' && Object.keys(filter).length > 0) {
            $scope.searchApplied = true;
            params.filter = filter;
        }
        
        $scope.loadingData = true;
        $api.get($scope.module + '/FetchRelatedRecords', params).success(function(result) {
            $scope.loadingData = false;
            $scope.tasksRecordsLoaded = false;
            $scope.noTasksRecords = false;
            $scope.showMoreTasks = false;
            var tasksCount = result.records.length;
            $scope.relatedRecordsDateTimeFields =  result.dateTimeFields;
			$scope.relatedRecordsDateFields =  result.dateFields;
            if (tasksCount === 0) {
                $scope.tasksRecords = [];
                $scope.noTasksRecords = false;
                $scope.tasksRecordsLoaded = true;
            }
            if ($scope.tasksPageNo === 1 && tasksCount > 0) {
                $scope.tasksRecords = result.records;
                $scope.showMoreTasks = result.more;
                $scope.tasksHeaders = result.headers;
                if (tasksCount < 10){
                    $scope.tasksRecordsLoaded = false;
                    $scope.noTasksRecords = true;
                  }
            } else if ($scope.tasksPageNo!==1){
                $scope.showMoreTasks = result.more;
                if (tasksCount === 0)
                    $scope.tasksRecordsLoaded = true;
                var tasksRecords = angular.copy(result.records);
                angular.forEach(tasksRecords, function(taskRecord) {
                    $scope.tasksRecords.push(taskRecord);
                });
                if (tasksCount < 10) {
                    $scope.tasksRecordsLoaded = false;
                    $scope.noTasksRecords=true;
                }
            }
        });
    }

    $scope.loadProjectTasks = function(pageNo) {
        if (pageNo === undefined) {
            $scope.projectTaskPageNo = 1;
        }
        else {
            $scope.projectTaskPageNo = pageNo
        }
        var params = {
            'relatedModule': 'ProjectTask',
            'id': $scope.id,
            'relatedModuleLabel': 'Project Tasks',
            'page': $scope.projectTaskPageNo
        }
        $scope.loadingData = true;
        $api.get($scope.module + '/FetchRelatedRecords', params).success(function(result) {
            $scope.loadingData = false;
            $scope.tasksLoaded = false;
            $scope.noTasks = false;
            $scope.showMoreProjectTasks = false;
            var tasksCount = result.records.length;
            $scope.relatedRecordsDateTimeFields =  result.dateTimeFields;
			$scope.relatedRecordsDateFields =  result.dateFields;
            if (tasksCount === 0) {
                $scope.noTasks = false;
                $scope.tasksLoaded = true;
            }
            if ($scope.projectTaskPageNo === 1 && tasksCount > 0) {
                $scope.projecttaskrecords = result.records;
                $scope.showMoreProjectTasks = result.more;
                $scope.projecttaskheaders = result.headers;
                if (tasksCount < 10){
                    $scope.tasksLoaded = false;
                    $scope.noTasks = true;
                  }
            }
            else if ($scope.projectTaskPageNo!==1){
                $scope.showMoreProjectTasks = result.more;
                if (tasksCount === 0)
                    $scope.tasksLoaded = true;
                var projectTaskRecords = angular.copy(result.records)
                angular.forEach(projectTaskRecords, function(taskRecord) {
                    $scope.projecttaskrecords.push(taskRecord)
                });
                if (tasksCount < 10) {
                    $scope.tasksLoaded = false;
                    $scope.noTasks=true;
                }
            }
        });
    }

    $scope.loadProjectMilestones = function(pageNo) {
        if (pageNo === undefined) {
            $scope.projectMilestonePageNo = 1;
        }
        else {
            $scope.projectMilestonePageNo = pageNo
        }
        var params = {
            'relatedModule': 'ProjectMilestone',
            'id': $scope.id,
            'relatedModuleLabel': 'Project Milestones',
            'page': $scope.projectMilestonePageNo
        }
        $scope.loadingData = true;
        $api.get($scope.module + '/FetchRelatedRecords', params).success(function(result) {
          $scope.loadingData = false;
          $scope.milestonesLoaded = false;
          $scope.relatedRecordsDateTimeFields =  result.dateTimeFields;
		  $scope.relatedRecordsDateFields =  result.dateFields;
          $scope.noMilestones = false;
          $scope.showMoreProjectMileStones = false;
          var milestoneCount = result.records.length;
            if (milestoneCount === 0) {
                $scope.noMilestones = false;
                $scope.milestonesLoaded = true;
            }
            if ($scope.projectMilestonePageNo === 1 && milestoneCount>0) {
                $scope.projectmilestonerecords = result.records;
                $scope.projectmilestoneheaders = result.headers;
                $scope.showMoreProjectMileStones = result.more;
                if(milestoneCount < 10){
                  $scope.milestonesLoaded = false;
                  $scope.noMilestones = true;
                }
            }
            else if ($scope.projectMilestonePageNo!==1){
                if (milestoneCount === 0)
                    $scope.milestonesLoaded = true;
                var projectMilestoneRecords = angular.copy(result.records)
                $scope.showMoreProjectMileStones = result.more;
                angular.forEach(projectMilestoneRecords, function(milestoneRecord) {
                    $scope.projectmilestonerecords.push(milestoneRecord)
                });

                if(milestoneCount < 10){
                  $scope.milestonesLoaded = false;
                  $scope.noMilestones = true;
                }
            }
        });
    }

    $scope.loadProjectTaskPage = function(pageNo) {
        $webapp.busy(false);
        $scope.loadProjectTasks(pageNo + 1)
    }
    
    $scope.loadTasksPage = function(pageNo) {
        $webapp.busy(false);
        $scope.loadTasks(pageNo + 1);
    }
    
    $scope.loadProjectMilestonePage = function(pageNo) {
        $webapp.busy(false);
        $scope.loadProjectMilestones(pageNo + 1)
    }
    
    $scope.isRelatedRecordDateTimeField = function(fieldname,dateTimeFields){
  		var returnValue = false;
  		if(dateTimeFields.indexOf(fieldname)!==-1){
  			returnValue = true;
  		}
  		return returnValue;
  	}
	
	$scope.isRelatedRecordDateField = function(fieldname, dateFields) {
  		var returnValue = false;
  		if(dateFields.indexOf(fieldname) !== -1) {
  			returnValue = true;
  		}
  		return returnValue;
  	}
});

portalapp.controller("Project_Summary_Component",function( $scope, $api, $cache) {
    var seriesClickEvent = 'cp::pie::series::clicked';
    $scope.summaryLoaded = false;
    $scope.groupby = 'taskstatus';
    $scope.charttype = 'pie';
    $scope.charts = {};
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
    
    $scope.changeGroupBy = function(groupby) {
        $scope.groupby = groupby;
        $scope.loadProjectSummary();
    }
    
    $scope.loadProjectSummary = function() {
        var params = {'groupby' : $scope.groupby, filter : {'related_project' : $scope.id}};
        $scope.summaryLoaded = false;
        $api.get('Calendar/FetchRecordsCountByField', params).success(function(result) {
            $scope.summaryLoaded = true;
            var counts = result.count;
            var data = [];
            var picklistLabels = $scope.picklistFieldValues[$scope.groupby];
            for(var key in counts) {
                var _key = picklistLabels[key] ? picklistLabels[key] : key;
                data.push([_key, parseFloat(counts[key])]);
            }
            $scope.charts['Tasks by'] = {data : data, type : $scope.charttype, showmodulepicklist : true , seriesname : 'Tasks', 'seriesclickevent' : seriesClickEvent};
        });
    }
    
    $scope.$on(seriesClickEvent, function(e, data) {
        // applying filter and loading tasks
        var filterCacheKey= 'Project_Calendar_filter_fields';
        var filter = {};
        
        var picklistLabels = $scope.picklistFieldValues[$scope.groupby];
        var value = Object.keys(picklistLabels).find(key => picklistLabels[key] === data.name);
        filter[$scope.groupby] = [value ? value : data.name];
        $cache.set(filterCacheKey, JSON.stringify(filter));
        $scope.$emit('cp::related::filter::updated', 'Calendar');
        
        // Making tasks tab active
        $scope.selectedTab('Calendar');
        jQuery('.rightEditContent .nav-tabs li[heading="Calendar"] a').click();
    });
    
    $scope.init = function() {
        $api.getDescribe('Calendar').success(function(describe) {
            var picklistFields = [];
            var picklistFieldValues = {};
            var moduleDescribe = describe.describe;
            var fields = moduleDescribe.fields;
            for(var i in fields) {
                var field = fields[i];
                if(['picklist', 'metricpicklist', 'multipicklist', 'radio'].includes(field.type.name) && moduleDescribe.filterFieldsInfo[field.name] != "") {
                    picklistFields.push({value : field.name, label : field.label});
                    
                    picklistFieldValues[field.name] = {};
                    for(var i in field.type.picklistValues) {
                        var picklist = field.type.picklistValues[i];
                        picklistFieldValues[field.name][picklist['value']] = picklist['label'];
                    }
                    
                }
            }
            $scope.picklistFieldValues = picklistFieldValues;
            $scope.picklistFields = picklistFields;
            $scope.loadProjectSummary();
        });
    }
    
    $scope.init();
});