/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/
portalapp.controller("Portal_IndexView_Component",function( $scope, $api, $webapp, sharedModalService, $translatePartialLoader, $modal, $http, downloadAttachment, $cache ) {
	/*@ngInject*/
	var url = purl();
	$scope.module = url.param( 'module' );
	$scope.pageInitialized = false;
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
	
	$scope.searchQ = {
		onlymine: true
	}
	if(typeof $scope.module != 'undefined' && localStorage.getItem('moduleWiseScopeFilter')){
		var moduleScopeFilter = JSON.parse(localStorage.getItem('moduleWiseScopeFilter'));
		moduleScopeFilter = moduleScopeFilter[$scope.module];
	}
	if(moduleScopeFilter && moduleScopeFilter != 'undefined'){
		if(moduleScopeFilter.toUpperCase() == 'ALL'){
			$scope.searchQ.onlymine = false;
		}
	}else if(localStorage.getItem('scopefilter')){
		var scopefilter = localStorage.getItem('scopefilter');
		if(scopefilter && scopefilter.toUpperCase() == 'ALL'){
			$scope.searchQ.onlymine = false;
		}
	}else{
		$api.get('Portal/FetchDefaultScopeFilter').success(function(response){
			var scopefilter = response.scopefilter;
			localStorage.setItem('scopefilter',scopefilter);
			if(scopefilter && scopefilter.toUpperCase() == 'ALL'){
				$scope.searchQ.onlymine = false;
			}
		});
	}
	$scope.pageNo = 0;
	$scope.headers = null;
	$scope.records = null;
	$scope.extheaders = null;
	$scope.extrecords = null;
	$scope.currentPage = 1;
	$scope.pageSize = 10;
	$scope.isCreatable = false;
	$scope.isEditable = false;
	$scope.exportEnabled = false;
        $scope.isFilterEnabled = false;
	var availableModules = JSON.parse( localStorage.getItem( 'modules' ) );
	var currentModule = $scope.module;
    
    $scope.$root.$on('LoginUser.Ready', function () {
        // Re-initialize all modules if not available
        if (!availableModules) availableModules = $scope.modules;
        if(!currentModule) currentModule = $scope.module;
        if (!jQuery.isEmptyObject(currentModule)) {
            var ptitleLabel = availableModules[ currentModule ].uiLabel;
            $scope.ptitle = ptitleLabel;
            //set creatable true
            $scope.isCreatable = availableModules[ currentModule ].create;
            $scope.filterPermissions = availableModules[currentModule].recordvisibility;
        }
        
        if ($translatePartialLoader !== undefined) {
            $translatePartialLoader.addPart('home');
            if ($scope.module !== undefined)
                $translatePartialLoader.addPart($scope.module);
        }
        
        if ( $scope.module !== undefined && availableModules && availableModules[$scope.module]) {
            $webapp.busy();
			$scope.loadRecords();
        }
    });


	$scope.$watch( 'searchQ.onlymine', function ( nvalue, ovalue ) {
		if ( nvalue != ovalue ) {
			var availableModules = JSON.parse(localStorage.getItem('modules'));
			if($scope.module !== undefined && availableModules && availableModules[$scope.module]){
				$scope.loadRecords( $scope.pageNo );
				$scope.currentPage = 1;
				var scopeFilter = nvalue == true ? 'Mine' : 'All';
				if($scope.module){
					var moduleScopeFilterObj = {};
					if(localStorage.getItem('moduleWiseScopeFilter') && localStorage.getItem('moduleWiseScopeFilter') !== 'undefined'){
						moduleScopeFilterObj = JSON.parse(localStorage.getItem('moduleWiseScopeFilter'));
					}
					moduleScopeFilterObj[$scope.module] = scopeFilter;
					localStorage.setItem('moduleWiseScopeFilter',JSON.stringify(moduleScopeFilterObj));
				}
			}
		}
	} );
	if ( $scope.module !== 'HelpDesk' ) {
		localStorage.removeItem( 'currentStatus' );
	}

	$scope.loadRecords = function ( pageNo ) {
		var params = {};
		$webapp.busy( false );
		$scope.itemsPerPage = 10;
		if ( $scope.module !== undefined )
			var label = availableModules[ $scope.module ].label;
		if ( $scope.searchQ.onlymine ) {
			$scope.searchQ.mode = 'mine';
		} else {
			$scope.searchQ.mode = 'all';
		}
		if ( $scope.sortParams === undefined ) {
			params = {
				'mode': $scope.searchQ.mode,
				'page': pageNo
			}
		} else if ( $scope.sortParams !== undefined ) {
			params = $scope.sortParams;
		}
                
                // selected filters, to load records as per selected filters.
                var filter = {};
                var filterFieldsInfo = localStorage.getItem($scope.module + "_filter_fields");
                filterFieldsInfo = filterFieldsInfo ? filterFieldsInfo : '';
                if(filterFieldsInfo) {
                    filterFieldsInfo = JSON.parse(filterFieldsInfo);
                    angular.forEach(filterFieldsInfo, function(values, fieldName){
                        if(values.length) {
                            filter[fieldName] = values;
                        }
                    });
                }
                
		$api.get( $scope.module + '/FetchRecords', {
				label: label,
				q: params,
                                filter: filter
			} )
			.success( function ( result ) {
				$webapp.busy( false );
				$scope.pageInitialized = true;

				if ( result.count === undefined && $scope.module !== undefined && $scope.module !== 'HelpDesk' ) {
					alert( result.message );
					window.location.href = "index.php?view=Logout";
				}
				$scope.headers = result.headers;
				$scope.records = result.records;
				$scope.edits = result.editLabels;
				$scope.dateTimeFields = result.dateTimeFields;
				$scope.dateFields = result.dateFields;
				$scope.totalPages = result.count;
			} );
	}

	$scope.ChangeLocation = function ( record, $event ) {
		if($event.target.nodeName !== 'A'){
			var selectedMode = $scope.searchQ.onlymine ? 'mine' : 'all';
			var url = "index.php?module=" + $scope.module + "&view=Detail&id=" + record.id + "&selectedMode=" + selectedMode;
			window.location = url;
		}
	}

	$scope.hoverIn = function () {
		$scope.hoverEdit = true;
	};

	$scope.hoverOut = function () {
		$scope.hoverEdit = false;
	};


	$scope.downloadFile = function ( recordId ) {
		var fileUrl = 'index.php?module=' + $scope.module + '&api=DownloadFile&recordId=' + recordId;
		$webapp.busy(true);
		downloadAttachment({'module':$scope.module,'recordId':recordId})
	};
    
    $scope.previewFile = function(module, record) {
        if(record['file_url']) {
            $modal.open( {
                templateUrl: "filePreviewModal.template",
                controller: 'Portal_FilePreview_Component',
                backdrop: "static",
                size: "lg",
                resolve: {
                    module: function () {
                        return module;
                    },
                    record: function () {
                        return record;
                    },
                    api : function() {
                        return $api;
                    },
                    fromRelatedList : function() {
                        return false;
                    }
                }
            });
        }
    };
    
	$scope.setSortOrder = function ( header ) {
		var order = 'ASC';
		if ( header == $scope.OrderBy ) {
			$scope.reverse = !$scope.reverse;
		}
		if ( $scope.reverse && $scope.OrderBy !== undefined ) {
			order = 'DESC';
		}
		$scope.OrderBy = header;
		var params = {
			'page': $scope.currentPage - 1,
			'mode': $scope.searchQ.mode,
			'order': order,
			'orderBy': $scope.edits[ header ]
		}
		if ( $scope.loadPage !== undefined ) {
			params.page = $scope.loadPage;
		}
		$scope.sortParams = params;
		$scope.loadRecords();
	}

	$scope.pageChanged = function ( pageNo ) {
		$scope.loadPage = pageNo - 1;
		if ( $scope.sortParams !== undefined ) {
			$scope.sortParams.page = pageNo - 1;
			$scope.loadRecords();
		} else {
			$scope.loadRecords( pageNo - 1 );
		}
	}

	//Generic craete record Modal.
	$scope.createRecord = function ( module ) {
		var modalInstance = $modal.open( {
			templateUrl: "createRecordModal.template",
			controller: 'Portal_CreateView_Component',
			backdrop: "static",
            keyboard: 'false',
			size: "lg",
			resolve: {
				record: function () {
                    return {};
                },
                api: function () {
                   return $api;
                },
                webapp: function () {
                   return $webapp;
                },
                module: function () {
                   return $scope.module;
                },
                language: function () {
                   return $scope.$parent.language;
                },
                editStatus: function () {
                   return false;
                },
                fromRelatedList : function() {
                    return false;
                },
			}
		} );
	}
        
    $scope.openFilter = function(module) {
        $modal.open({
            templateUrl: "filterModal.template",
            controller: 'Portal_FilterView_Component',
            backdrop: 'static',
            keyboard: 'false',
            scope: $scope,
            size: 'sm',
            resolve: {
                module: function () {
                    return $scope.module;
                },
                api: function () {
                    return $api;
                },
                webapp: function () {
                    return $webapp;
                },
                language: function () {
                    return $scope.$parent.language
                },
                editStatus: function () {
                    return true;
                },
                record: function () {
                    return $scope.record;
                }
            }
        });
    }

	$scope.checkRecordsVisibility = function(filterValue){
		var returnValue;
		switch (filterValue) {
			case "1":
				returnValue = true;
				break;
			case "0":
				returnValue = false;
				break;
			case "2":
				returnValue = false;
				break;
			default:
				returnValue = false;
		}
		return returnValue;
	}
	
	$scope.isDateTimeField  = function(fieldname,dateTimeFields){
		var returnValue = false;
		if(dateTimeFields && $scope.dateTimeFields.indexOf(fieldname)!==-1){
			returnValue = true;
		}
		return returnValue;
	}
	
	$scope.isDateField  = function(fieldname) {
		var returnValue = false;
		if($scope.dateFields.indexOf(fieldname) !== -1) {
			returnValue = true;
		}
		return returnValue;
	}
    
    $scope.$on('cp::filter::updated', function() {
        var appliedFilters = $cache.get($scope.module + '_filter_fields');
        var appliedFiltersCount = 0;
        angular.forEach(appliedFilters, function(values, fieldName) {
            if(values.length) {
                appliedFiltersCount++;
            }
        });
        $scope.appliedFiltersCount = appliedFiltersCount;
    });
    $scope.$emit('cp::filter::updated'); // for first time load
});

portalapp.controller("Portal_DetailView_Component",function( $scope, $api, $webapp, $translatePartialLoader, $modal,jstz, downloadAttachment, $controller, $cache, $preferences) {
	/*@ngInject*/
	var url = purl();
	$scope.module = url.param( 'module' );
	$scope.id = url.param( 'id' );
    $scope.selectedCommentId = url.param('selectedCommentId');
	$scope.pageInitialized = false;
	$scope.splitContentView = false;
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();

	$scope.record = null;
	$scope.blocks = [];
	$scope.fields = [];

	$scope.isEditable = false;
	$scope.isCommentCreateable = false;
	$scope.updatesEnabled = false;
	$scope.commentsEnabled = false;
	$scope.comments = [];
    $scope.documentsrecords = [];
    $scope.tasksRecords = [];
    $scope.projecttaskrecords = [];
    $scope.projectmilestonerecords = [];
	$scope.newcomment = {};
    $scope.moduleRecordsKeyMap = {
        'Calendar' : 'tasksRecords',
        'Documents' : 'documentsrecords',
        'ProjectTask' : 'projecttaskrecords',
        'ProjectMilestone' : 'projectmilestonerecords',
        'ModComments' : 'comments',
        'History' : 'updates'
    }
    $scope.enabledRelatedModules = [];
    $scope.relatedRecords = {};
    $scope.relatedModuleHeaders = {};
    $scope.relatedRecordsData = {
        loading : {}, loaded : {}, page : {},
        noRecords : {}, showMore : {}
    };
    
    /**
     * If rollup is needed for any module, then add module here with value as 'from which module it should roll up'
     * Right now, we are showing Tasks related comments in Project when roll up
     */ 
    $scope.comments_rollup_map = {'Project' : 'Calendar'};
    if($scope.comments_rollup_map[$scope.module]) {
        $scope.comments_rollup_support = true;
    }

    $scope.comments_rollup = $preferences.get($scope.module+"_comments_rollup");
    $scope.commentsRollup = function(e) {
        $scope.comments_rollup = e.target.checked;
        $preferences.set($scope.module+"_comments_rollup", $scope.comments_rollup);
        $scope.loadComments();
    }
    
    $scope.updates_rollup_map = {'Project' : 'Calendar'};
    if($scope.updates_rollup_map[$scope.module]) {
        $scope.updates_rollup_support = true;
    }
    
    $scope.updates_rollup = $preferences.get($scope.module+"_updates_rollup");
    $scope.updatesRollup = function(e) {
        $scope.updates_rollup = e.target.checked;
        $preferences.set($scope.module+"_updates_rollup", $scope.updates_rollup);
        $scope.loadUpdates();
    }
    
    $scope.documents_rollup_map = {'Project' : 'Calendar'};
    if($scope.documents_rollup_map[$scope.module]) {
        $scope.documents_rollup_support = true;
    }
    
    $scope.documents_rollup = $preferences.get($scope.module+"_documents_rollup");
    $scope.documentsRollup = function(e) {
        $scope.documents_rollup = e.target.checked;
        $preferences.set($scope.module+"_documents_rollup", $scope.documents_rollup);
        $scope.loadDocuments();
    }

	var parentModules = {
		"ProjectTask": "Project",
		"ProjectMilestone": "Project"
	};
	var availableModules = JSON.parse( localStorage.getItem( 'modules' ) );
    // After login, if we redirect the portal user directly to record a detail view then 
    // it is failing to show record details because loading record happening before loading all 
    // the available modules. So added watcher to load record after loading modules.
    $scope.init = function(availableModules) {
        $scope.ptitle = availableModules[ $scope.module ].uiLabel;
        // Checks and logic added to provide bread crumb navigation.
        if ( parentModules.hasOwnProperty( $scope.module ) ) {
            // $scope.ptitle = availableModules[parentModules[$scope.module]].uiLabel+'bread'+availableModules[$scope.module].uiLabel
            $scope.ptitle = availableModules[ parentModules[ $scope.module ] ].uiLabel;
            $scope.childModuleUiLabel = availableModules[ $scope.module ].uiLabel;
        }

        //Set editable true
        $scope.isEditable = availableModules[ $scope.module ].edit;
        $scope.isPreviewAllowed = availableModules[ $scope.module ].preview;
        $scope.isDownloadAllowed = availableModules[ $scope.module ].download;
            
        $scope.updates = [];
        if ( $translatePartialLoader !== undefined ) {
            $translatePartialLoader.addPart( 'home' );
            $translatePartialLoader.addPart( $scope.module );
        }

        if ( $scope.module !== 'HelpDesk' ) {
            localStorage.removeItem( 'currentStatus' );
        }

        setTimeout( function () {
            var isUpdate = false;
            $scope.loadRecord(isUpdate);
        }, 300 );
    }
    
    if(availableModules) {
        $scope.init(availableModules);
    } else {
        $scope.$watch('modules', function(newValue, oldValue) {
            var modules = localStorage.getItem('modules');
            if(modules) {
                availableModules = JSON.parse(modules);
                $scope.init(availableModules);
            }
        });
    }
    
    $scope.$on('cp::related::filter::updated', function(e, relModule) {
        // making records empty. Since filter is applied which should reload from page 1
        $scope[$scope.moduleRecordsKeyMap[relModule]] = [];
        if(relModule) $scope.relatedRecords[relModule] = [];
        // Setting applied filter to cache. So, load records will use this to filter
        var appliedFilters = $cache.get($scope.module+"_"+relModule+"_filter_fields");
        var appliedFiltersCount = 0;
        angular.forEach(appliedFilters, function(values, fieldName) {
            if(values.length) {
                appliedFiltersCount++;
            }
        });
        var key = relModule+"_appliedFiltersCount";
        $scope[key] = appliedFiltersCount;
    });

	$scope.loadRecord = function (isUpdate) {
		var language = $scope.$parent.language;
		if(!isUpdate){
	        $webapp.busy();
	    }
		$scope.parentId = url.param( 'parentId' );
		$scope.selectedMode = url.param('selectedMode');
        $scope.$parent.fetchRecord($scope.module, $scope.id, {scope : $scope, isUpdate : isUpdate}).success(function() {
            $scope.updateRTEFields = function() {
                // To show RTE fields on right side as related tabs in record detail view.
                $scope['rteFieldValues'] = {};
                angular.forEach($scope.rteFields, function (fieldLabel, fieldName) {
                    $scope.relatedModules[Object.keys($scope.relatedModules).length] = {'name': fieldName, 'value': 1, 'uiLabel': fieldLabel};
                    $scope['rteFieldValues'][fieldName] = $scope.record[fieldLabel];
                    $scope.splitContentView = !$scope.splitContentView ? true : $scope.splitContentView;
                });
            }
            if($scope.relatedModules) {
                $scope.updateRTEFields();
            } else {
                $scope.$watch('relatedModules', function () {
                    if($scope.relatedModules) {
                        $scope.updateRTEFields();
                    }
                });
            }
        });
        
        $api.fetchRelatedModules($scope.module).success( function ( modules ) {
            var relatedModules = modules;
            var enabledModules = [];
            var relatedTab = url.param('relatedtab');
            angular.forEach( relatedModules, function ( relModule, i ) {
                relModule['active'] = (relModule.name == relatedTab) ? true : false; 
                if ( relModule.name === 'History' ) {
                    $scope.updatesEnabled = ( relModule.value === 1 ) ? true : false;
                    relatedModules[ i ].uiLabel = 'History';
                    enabledModules.push(relModule.name);
                }
                else if ( relModule.name === 'ModComments' ) {
                    $scope.commentsEnabled = ( relModule.value === 1 ) ? true : false;
                    relatedModules[ i ].uiLabel = 'ModComments';
                    enabledModules.push(relModule.name);
                }
                else if ( $scope.module == 'Project' && relModule.name === 'Calendar' ) {
                    $scope.tasksEnabled = ( relModule.value === 1 ) ? true : false;
                    relatedModules[ i ].uiLabel = availableModules.Calendar.uiLabel;
                    enabledModules.push(relModule.name);
                }
                else if ( relModule.name === 'Documents' ) {
                    $scope.documentsEnabled = ( relModule.value === 1 ) ? true : false;

                    relatedModules[ i ].uiLabel = availableModules.Documents.uiLabel;
                    enabledModules.push(relModule.name);
                } else {
                    $scope[relModule.name+'Enabled'] = ( relModule.value === 1 ) ? true : false;
                    relatedModules[ i ].uiLabel = availableModules[relModule.name] ? availableModules[relModule.name].uiLabel : relModule.name;
                    enabledModules.push(relModule.name);
                    $scope.enabledRelatedModules[relModule.name] = true;
                }
                
                // We are setting applied filters count in this event
                $scope.$emit('cp::related::filter::updated', relModule.name);
            });
            $scope.relatedModules = relatedModules;
            if (enabledModules.length!==0) {
                $scope.splitContentView = true;
            }
        });
	}
    
	$scope.selectedTab = function ( selected ) {
        //To maintain the selected tab even though after a refresh.
        if($scope.selection === selected) {
            return;
        }
		var url = window.location.href;
        var urlParams = new URL(url);
        var searchParams = new URLSearchParams(urlParams.search);
        searchParams.set('relatedtab', selected);
        $scope.selection = selected;
        url = window.location.origin + window.location.pathname + "?" + searchParams.toString();
        var obj = {Url: url};
        window.history.pushState(obj, '', obj.Url);
        loadSelectedTabData(selected);
	}
    
    var loadSelectedTabData = function(selected) {
        switch(selected) {
            case 'History':
                if($scope.updatesEnabled && !$scope.updates.length) {
                    $scope.loadUpdates();
                }
                break;
            case 'ModComments':
                if($scope.commentsEnabled && !$scope.comments.length) {
                    $scope.loadComments();
                }
                break;
            case 'Calendar' :
                if ( $scope.tasksEnabled && !$scope.tasksRecords.length ) {
                    $scope.loadTasks();
                }
                break;
            case 'Documents':
                if ( $scope.documentsEnabled && !$scope.documentsrecords.length ) {
                    $scope.loadDocuments();
                }
            default :
                if ( $scope.enabledRelatedModules[selected] && (!$scope.relatedRecords[selected] || !$scope.relatedRecords[selected].length)) {
                    $scope.loadRelatedRecords(selected);
                }
                break;    
        }
    }

    $scope.loadRelatedRecords = function(module,pageNo) {
        if (pageNo === undefined) {
            $scope.relatedRecordsData['page'][module] = 1;
        }
        else {
            $scope.relatedRecordsData['page'][module] = pageNo
        }
        var params = {
            'relatedModule': module,
            'id': $scope.id,
            'page': $scope.relatedRecordsData['page'][module]
        }
        $scope.relatedRecordsData['loading'][module] = true;
        $api.get($scope.module + '/FetchRelatedRecords', params).success(function(result) {
            $scope.relatedRecordsData['loading'][module] = false;
            $scope.relatedRecordsData['loaded'][module] = false;
            $scope.relatedRecordsData['noRecords'][module] = false;
            $scope.relatedRecordsData['showMore'][module] = false;
            var recordsCount = result.records.length;
            $scope.relatedRecordsDateTimeFields =  result.dateTimeFields;
			$scope.relatedRecordsDateFields =  result.dateFields;
            if (recordsCount === 0) {
                $scope.relatedRecordsData['noRecords'][module] = false;
                $scope.relatedRecordsData['loaded'][module] = true;
            }
            if ($scope.relatedRecordsData['page'][module] === 1 && recordsCount > 0) {
                $scope.relatedRecords[module] = result.records;
                $scope.relatedRecordsData['showMore'][module] = result.more;
                $scope.relatedModuleHeaders[module] = result.headers;
                if (recordsCount < 10){
                    $scope.relatedRecordsData['loaded'][module] = false;
                    $scope.relatedRecordsData['noRecords'][module] = true;
                  }
            }
            else if ($scope.relatedRecordsData['page'][module] !== 1 ){
                $scope.relatedRecordsData['showMore'][module] = result.more;
                if (recordsCount === 0)
                $scope.relatedRecordsData['loaded'][module] = true;
                var fetchedRecords = angular.copy(result.records)
                angular.forEach(fetchedRecords, function(relatedRecord) {
                    $scope.relatedRecords[module].push(relatedRecord)
                });
                if (recordsCount < 10) {
                    $scope.relatedRecordsData['loaded'][module] = false;
                    $scope.relatedRecordsData['noRecords'][module] = true;
                }
            }
        });
    }

    $scope.loadMoreRelatedRecords = function(module) {
        $webapp.busy(false);
        $scope.loadRelatedRecords(module, $scope.relatedRecordsData['page'][module] + 1)
    }

	$scope.loadComments = function ( pageNo ) {
		if ( pageNo === undefined || isNaN(pageNo) ){
			$scope.commentPageNo = 1;
		}else{
			$scope.commentPageNo = pageNo
		}	
		$scope.parentId = url.param( 'parentId' );
		var params = {
			'relatedModule': 'ModComments',
			'id': $scope.id,
			'parentId': $scope.parentId,
			'page': $scope.commentPageNo
		}
        if($scope.comments_rollup && $scope.comments_rollup_map[$scope.module]) {
            // Server expects a related module to which we want to roll up. 
            // For Projects we are sending Calendar, to see related Tasks comments too
            params['roll_up_to'] = $scope.comments_rollup_map[$scope.module];
        }
        $scope.loadingData = true;
		$api.get( $scope.module + '/FetchRelatedRecords', params )
			.success( function ( comments ) {
                $scope.loadingData = false;
                $scope.commentsLoaded = false;
				$scope.noComments = false;
				$scope.showMoreComments = false;
				var comments = comments.comments;
				$scope.showMoreComments = comments.more;
				delete(comments['more']);
				if ( comments === null ) {
					$scope.noComments = true;
					$scope.commentsLoaded = false;
				}
				if ( comments !== null )
					var commentCount = comments.length;
				var commentList = [];
				if ( $scope.commentPageNo == 1 ) {
					angular.forEach( comments, function ( comment ) {
						commentList.push( comment );
					} );
					var scopeComments = angular.copy( commentList );
					$scope.comments = scopeComments;
					if ( commentCount < 10 ) {
						$scope.commentsLoaded = true;
					}
				} else {
					if ( comments === null )
						$scope.commentsLoaded = true;
					var newCommentList = [];
					angular.forEach( comments, function ( comment ) {
						if ( angular.isObject( comment ) )
							$scope.comments.push( comment );
					} );
					if ( commentCount < 10 ) {
						$scope.commentsLoaded = true;
					}
				}
                
                if ($scope.selectedCommentId) {
                    setTimeout(function () {
                        if (jQuery('[name="comment-' + $scope.selectedCommentId + '"]').length) {
                            window.location.href = "#comment-" + $scope.selectedCommentId;
                        } else {
                            $scope.loadCommentsPage($scope.commentPageNo);
                        }
                    }, 500);
                }
                
			} );
	}


	$scope.addComment = function ( validity ) {
		$scope.parentId = url.param( 'parentId' ) !== undefined ? url.param( 'parentId' ) : '';
		$scope.newcomment.parentId = $scope.parentId;
		$scope.comments = $scope.comments || {};
		$scope.newcomment.related_to = $scope.id;
		if ( validity ) {
			$scope.commentValidate = false;
			$scope.savingComment = true;
			$webapp.busy();
			$api.post( 'ModComments/AddComment', {
					comment: $scope.newcomment
				} )
				.success( function ( comment ) {
					$webapp.busy( false );
					if ( $scope.comments !== null ) {
						$scope.comments = $scope.comments || [];
						$scope.loadComments()
						$scope.comments.unshift( comment );
					} else {
						$scope.comments.push( comment );
						$scope.savingComment = false;
					}
					$scope.newcomment = {};
					$scope.savingComment = false;
                    //Redmine - Bug #42639 - Case status not getting changed from Assigned to Open if reply done from portal.
                    if($scope.module!==undefined && $scope.module ==='Cases' && ($scope.hasOwnProperty('CasesMarkCaseOpen') && $scope.CasesMarkCaseOpen)){
                         var statusField = $scope.edits['casestatus'];
                         $scope.record[statusField] = $scope.CasesOpenLabel;
						 setTimeout(function () {
							$scope.loadRecord(true);
						 }, 300);
                    }
				});
		} else {
			$scope.commentValidate = true;
			return false;
		}
	};
    
	$scope.loadUpdates = function ( pageNo, createdStatus ) {
		var language = $scope.$parent.language;
		if ( $scope.module == 'ProjectTask' || $scope.module == 'ProjectMilestone' ) {
			var parentId = $scope.parentId;
		}
		if ( pageNo === undefined ) {
			$scope.historyPageNo = 0;
		} else {
			$scope.historyPageNo = pageNo
		}
        var pageLimit = 10;
        var params = {
            id: $scope.id,
            page: $scope.historyPageNo,
            language: language,
            parentId: parentId,
            selectedMode: $scope.selectedMode,
            pageLimit : pageLimit
        };
        if($scope.updates_rollup && $scope.updates_rollup_map[$scope.module]) {
            // Server expects a related module to which we want to roll up. 
            // For Projects we are sending Calendar, to see related Tasks updates too
            params['roll_up_to'] = $scope.updates_rollup_map[$scope.module];
        }
        
        $scope.loadingData = true;
		$api.get( $scope.module + '/FetchHistory', params )
			.success( function ( updates ) {
                $scope.noMoreUpdates = false;
                $scope.loadingData = false;
				$webapp.busy( false );
				var recordUpdates = updates.records;
                var recordsCount = updates.count;
                $scope.updateCount = recordsCount;
                
                if(recordsCount < pageLimit) {
                    $scope.noMoreUpdates = true;
                }
                
				if ( recordUpdates !== null ) {
                    if ( $scope.historyPageNo == 0 ) {
                        var updateList = [];
                        angular.forEach( recordUpdates, function ( recUpdate ) {
                            updateList.push( recUpdate )
                        });
                        $scope.updates = angular.copy( updateList );
                    } else {
                        angular.forEach( recordUpdates, function ( update ) {
                            $scope.updates.push( update );
                        });
                    }
				} else
					$scope.updates = '';
			} );
	};

	$scope.loadDocuments = function ( pageNo ) {
		if ( pageNo === undefined ) {
			$scope.documentsPageNo = 1;
		} else {
			$scope.documentsPageNo = pageNo
		}
		var params = {
			'relatedModule': 'Documents',
			'id': $scope.id,
			'relatedModuleLabel': 'Documents',
			'page': $scope.documentsPageNo
		}
        
        if($scope.documents_rollup && $scope.documents_rollup_map[$scope.module]) {
            // Server expects a related module to which we want to roll up. 
            // For Projects we are sending Calendar, to see related Tasks documents too
            params['roll_up_to'] = $scope.documents_rollup_map[$scope.module];
        }
        
		$scope.loadingData = true;
        $api.get( $scope.module + '/FetchRelatedRecords', params )
			.success( function ( result ) {
                $scope.loadingData = false;
                var availableModules = JSON.parse( localStorage.getItem( 'modules' ) );
                $scope.isDocEditable = availableModules['Documents'].edit;
                $scope.isDocPreviewAllowed = availableModules['Documents'].preview;
                $scope.isDocDownloadAllowed = availableModules['Documents'].download;
                
				// $webapp.busy(false);
				$scope.documentsLoaded = false;
				$scope.noDocuments = false;
				$scope.showMoreDocuments = false;
				var documentsCount = result.records.length;
				$scope.showMoreDocuments = result.more;
				$scope.relatedRecordsDateTimeFields = result.dateTimeFields;
				$scope.relatedRecordsDateFields = result.dateFields;
				if ( documentsCount === 0 ) {
					$scope.noDocuments = true;
					$scope.documentsLoaded = false;
				}
				if ( $scope.documentsPageNo === 1 ) {
					$scope.documentsrecords = result.records;
					$scope.documentsheaders = result.headers;
					if ( documentsCount < 10 ) {
						$scope.documentsLoaded = true;
					}
				} else {
					if ( documentsCount === 0 )
						$scope.documentsLoaded = true;
					var documentsRecords = angular.copy( result.records )
					angular.forEach( documentsRecords, function ( documentRecord ) {
						$scope.documentsrecords.push( documentRecord )
					} );
					if ( documentsCount < 10 ) {
						$scope.documentsLoaded = true;
					}
				}
			} );
	}

    $scope.showRelatedRecords = function (module) {
        var modules = ['Summary','ModComments','History','Documents','Calendar'];
        var showRecords = false;
        if(!modules.includes(module)) {
            showRecords = true;
        }
        return showRecords;
    }

	$scope.downloadFile = function ( module, recordId, parentId ) {
		if ( parentId === undefined ) {
			parentId = $scope.parentId;
			$webapp.busy(true);
			downloadAttachment({'module':module,'recordId':recordId})
		} else {
			$webapp.busy(true);
			downloadAttachment({'module':module,'recordId':recordId,'parentId':parentId});
		}
	};
    
    $scope.previewFile = function(module, record) {
        if(record['file_url']) {
            $modal.open( {
                templateUrl: "filePreviewModal.template",
                controller: 'Portal_FilePreview_Component',
                backdrop: "static",
                size: "lg",
                resolve: {
                    module: function () {
                        return module;
                    },
                    record: function () {
                        return record;
                    },
                    api : function() {
                        return $api;
                    },
                    fromRelatedList : function() {
                        return true;
                    }
                }
            });
        }
    };

	$scope.downloadCommentFile = function(module, commentId, attachmentId) {
	  $webapp.busy(true);
	  downloadAttachment({'module':module,'recordId':commentId,'attachmentId':attachmentId});
    };

	$scope.isLanguage = function ( val ) {
		if ( angular.isObject( val ) )
			return true;
		else
			return false;
	};

	$scope.loadHistoryPage = function ( pageNo ) {
		$scope.loadUpdates( pageNo + 1, $scope.created );
		$webapp.busy( false );
	}

	$scope.loadCommentsPage = function ( pageNo ) {
		$scope.loadComments( pageNo + 1 );
		$webapp.busy( false );
	}

	$scope.loadDocumentsPage = function ( pageNo ) {
		$scope.loadDocuments( pageNo + 1 );
		$webapp.busy( false );
	}

	$scope.ChangeLocation = function ( module, record, target = "self" ) {
        var id = record;
        var parentId = $scope.id;
        if(typeof record == 'object') {
            id = record.id;
            parentId = record.parentId ? record.parentId : parentId;
        }
        var url = "index.php?module=" + module + "&view=Detail&id=" + id + "&parentId=" + parentId;
        if(target == '_blank') {
            window.open(url);
        } else {
            window.location.href = url;
        }
    }
		//Bread crumb navigation method.
	$scope.navigateBack = function ( module ) {

		var parentModules = {
			"ProjectMilestone": "Project",
			"ProjectTask": "Project"
		};
		var url = "index.php?module=" + module;
		if ( parentModules.hasOwnProperty( module ) ) {
			module = parentModules[ module ];
			url = "index.php?module=" + module + "&view=Detail&id=" + $scope.parentId;
		}
		window.location.href = url;
	}
    
    $scope.editRelRecord = function(module, record) {
        var recordId = record;
        var parentId = url.param( 'id' );
        if(typeof record == 'object') {
            recordId = record.id;
            parentId = record.parentId ? record.parentId : parentId;
        }
        $controller("Portal_RelatedEditView_Component",({$scope:$scope, module : module, record:recordId,parentId: parentId,language:$scope.language, parentScope : $scope.$parent}));
    }

	//Generic edit record.

	$scope.editRecord = function ( module, id ) {
		var modalInstance = $modal.open( {
			templateUrl: "editRecordModal.template",
			controller: 'Portal_CreateView_Component',
			backdrop: "static",
			size: "lg",
			resolve: {
				module: function () {
					return $scope.module;
				},
				api: function () {
					return $api;
				},
				webapp: function () {
					return $webapp;
				},
				language: function () {
					return $scope.$parent.language
				},
				editStatus: function () {
					return true;
				},
				record: function () {
					return $scope.record;
				},
                fromRelatedList : function() {
                    return false;
                }
			}
		} );
	}
	
	$scope.isDateTimeField = function(fieldname){
		var returnValue = false;
		if($scope.record.dateTimeFields && $scope.record.dateTimeFields.indexOf(fieldname)!==-1){
			returnValue = true;
		}
		return returnValue;
	}
	
	$scope.isDateField = function(fieldname) {
		var returnValue = false;
		if($scope.record.dateFields && $scope.record.dateFields.indexOf(fieldname) !== -1) {
			returnValue = true;
		}
		return returnValue;
	}
    
    $scope.isRTEField = function(fieldname) {
        var rteFields = $scope.rteFields;
        var isRTE = false;
        angular.forEach( rteFields, function ( fieldLabel ) {
            if(fieldname === fieldLabel) {
                isRTE = true;
                return true;
            }
        });
        return isRTE;
    }
    
	$scope.isRelatedRecordDateTimeField = function(fieldname,dateTimeFields){
		var returnValue = false;
		if(dateTimeFields && dateTimeFields.indexOf(fieldname)!==-1){
			returnValue = true;
		}
		return returnValue;
	}
	
	$scope.isRelatedRecordDateField = function(fieldname,dateFields) {
		var returnValue = false;
		if(dateFields && dateFields.indexOf(fieldname) !== -1) {
			returnValue = true;
		}
		return returnValue;
	}
    
    $scope.openFilter = function(module) {
        $modal.open({
            templateUrl: "filterModal.template",
            controller: 'Portal_Related_FilterView_Component',
            backdrop: 'static',
            keyboard: 'false',
            scope: $scope,
            size: 'sm',
            resolve: {
                module: function () {
                    return module;
                },
                api: function () {
                    return $api;
                },
                webapp: function () {
                    return $webapp;
                },
                language: function () {
                    return $scope.$parent.language
                },
                editStatus: function () {
                    return true;
                },
                record: function () {
                    return $scope.record;
                }
            }
        });
    }
});

portalapp.controller("PortalProfile_DetailView_Component",function( $scope, $api, $webapp, $translatePartialLoader, $http,$q, $modal) {
	/*@ngInject*/
	$scope.hoverEdit = [];
	if ( $translatePartialLoader !== undefined ) {
		$translatePartialLoader.addPart( 'home' );
		$translatePartialLoader.addPart( 'Profile' );
	}
	var profileModules = JSON.parse( localStorage.getItem('profileModules'));
	if (!profileModules) profileModules = $scope.profileModules;
	$webapp.busy();
	$api.get( 'Portal' + '/FetchProfile', {
		modules: profileModules
	}).success( function ( profile ) {
			$webapp.busy( false );
            $scope.noContactLogo = false;
            $scope.noAccountsLogo = false;
			$scope.showEdit = false;
			$scope.contactDetails = profile.customer_details;
            if($scope.contactDetails === ''){
                $scope.noContactLogo = true;
            }
            if(!profile.customer_details){
                $scope.noContactLogo = true;
            }
            if($scope.noContactLogo || !$scope.contactDetails.imagedata){
                $scope.noContactLogo = true;
            }
            if(!profile.company_details){
                $scope.noAccountsLogo = true;
            }
			if($scope.noAccountsLogo !== true){
				$scope.showEdit = true;
			}
			$scope.accountDetails = profile.company_details;
            if($scope.noAccountsLogo || !$scope.accountDetails.imagedata){
                $scope.noAccountsLogo = true;
            }
			if($scope.contactDetails && $scope.contactDetails.record === undefined && $scope.contactDetails.message !== undefined) {
				if($scope.contactDetails.message === 'Permission to perform the operation is denied' || $scope.contactDetails.message === 'Contacts module is disabled') {
					alert("Contacts module has been disabled.")
					window.location.href = "index.php?view=Logout";
				}
			}
			if($scope.accountDetails && $scope.accountDetails.record === undefined && $scope.accountDetails.message !== undefined) {
				if($scope.accountDetails.message === 'Permission to perform the operation is denied') {
					$scope.accountDetails = '';
				} else if($scope.accountDetails.message === 'Contacts module is disabled'){
					alert("Contacts module has been disabled.")
					window.location.href = "index.php?view=Logout";
				}
			}
			
			if ($scope.contactDetails) {
				var module = $scope.contactDetails.module;
				if($scope.contactDetails[module]) {
					$scope.contactDetails.record.referenceFields = $scope.contactDetails[module].referenceFields;
					$scope.contactDetails.record.multiCurrencySymbol = jQuery('<div></div>').html($scope.contactDetails[module].multiCurrencySymbol).text();
					$scope.contactDetails.record.dateTimeFields = $scope.contactDetails[module].dateTimeFields;
					$scope.contactDetails.record.dateFields = $scope.contactDetails[module].dateFields;
				}
			}
			
			if ($scope.accountDetails) {
				var module = $scope.accountDetails.module;
				if($scope.accountDetails[module]) {
					$scope.accountDetails.record.referenceFields = $scope.accountDetails[module].referenceFields;
					$scope.accountDetails.record.multiCurrencySymbol = jQuery('<div></div>').html($scope.accountDetails[module].multiCurrencySymbol).text();
					$scope.accountDetails.record.dateTimeFields = $scope.accountDetails[module].dateTimeFields;
					$scope.accountDetails.record.dateFields = $scope.accountDetails[module].dateFields;
				}
			}
		} );
		
	$scope.editRecord = function (module) {
		$scope.record = (module == 'Contacts') ? $scope.contactDetails.record : $scope.accountDetails.record;
		$scope.module = module;
		var modalInstance = $modal.open({
			templateUrl: "editRecordModal.template",
			controller: 'Portal_CreateView_Component',
			backdrop: "static",
			size: "lg",
			resolve: {
				module: function () {
					return $scope.module;
				},
				api: function () {
					return $api;
				},
				webapp: function () {
					return $webapp;
				},
				language: function () {
					return $scope.$parent.language
				},
				editStatus: function () {
					return true;
				},
				record: function () {
					return $scope.record;
				},
                fromRelatedList : function() {
                    return false;
                },
			}
		});
	}
	
	$scope.isDateTimeField = function(fieldname, module){
		var record = (module == 'Contacts') ? $scope.contactDetails.record : $scope.accountDetails.record;
		var returnValue = false;
		if(record.dateTimeFields && record.dateTimeFields.indexOf(fieldname)!==-1){
			returnValue = true;
		}
		return returnValue;
	}
	
	$scope.isDateField = function(fieldname, module) {
		var record = (module == 'Contacts') ? $scope.contactDetails.record : $scope.accountDetails.record;
		var returnValue = false;
		if(record.dateFields && record.dateFields.indexOf(fieldname) !== -1) {
			returnValue = true;
		}
		return returnValue;
	}
    
	$scope.saveContactDetails = function ( data, field, type ) {
        var d = $q.defer();
		var emailRegex = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
		var urlRegex = /^(?:(?:https?|ftp):\/\/)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u00a1-\uffff0-9]+-?)*[a-z\u00a1-\uffff0-9]+)(?:\.(?:[a-z\u00a1-\uffff0-9]+-?)*[a-z\u00a1-\uffff0-9]+)*(?:\.(?:[a-z\u00a1-\uffff]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/i
		var params = {
			"api": "saveRecord"
		};
		var record = {};
		record[ field ] = data;
		params.record = record;


		if ( type !== undefined && type === 'email' && !emailRegex.test( data ) ) {

			return 'Please enter a valid email address.';
		}

		if ( type !== undefined && type === 'weburl' && !urlRegex.test( data ) ) {

			return 'Please enter a valid url.';
		}
		if ( field === 'lastname' && data === '' ) {
			return 'Last name is required';
		}
		$webapp.busy( false );
		$http.post('index.php?module=Contacts&api=SaveRecord', params)
                .then(function (data) {

                    if (data.data.success && angular.isObject(data.data.result)) {
                        if (data.data.result[field] !== '' && data.data.result[ field ] == params.record[ field ]) {
                            d.resolve();
                        } else if (data.data.result.code !== 'undefined' && data.data.result.code !== 'undefined') {
                            d.reject(data.data.result.message);
                        } else {
                            d.reject('Record could not be saved');
                        }
                    } else {
                        d.reject('Result is not an object');
                    }
                });
        return d.promise;
	}


	$scope.saveOrganizationDetails = function ( data, field, type) {
        var d = $q.defer();
		var emailRegex = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
		var urlRegex = /^(?:(?:https?|ftp):\/\/)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u00a1-\uffff0-9]+-?)*[a-z\u00a1-\uffff0-9]+)(?:\.(?:[a-z\u00a1-\uffff0-9]+-?)*[a-z\u00a1-\uffff0-9]+)*(?:\.(?:[a-z\u00a1-\uffff]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/i
		var params = {
			"api": "saveRecord"
		};
		var record = {};
		record[ field ] = data;
		params.record = record;

		if ( type !== undefined && type === 'email' && !emailRegex.test( data ) ) {

			return 'Please enter a valid email address.';
		}

		if ( type !== undefined && type === 'weburl' && !urlRegex.test( data ) ) {

			return 'Please enter a valid url.';
		}
		if ( field === 'accountname' && data === '' ) {
			return 'Organization name is required';
		}
		$webapp.busy(false);
        $http.post('index.php?module=Accounts&api=SaveRecord', params)
                .then(function (data) {
                    if (data.data.success && angular.isObject(data.data.result)) {
                        if (data.data.result[field] !== '' && data.data.result[ field ] == params.record[ field ]) {
                            d.resolve();
                        } else if (data.data.result.code !== 'undefined' && data.data.result.code !== 'undefined') {
                            d.reject(data.data.result.message);
                        } else {
                            d.reject('Record could not be saved');
                        }
                    } else {
                        d.reject('Result is not an object');
                    }
                });
        return d.promise;
	}

	$scope.hoverEditIn = function ( item ) {
		$scope.hoverEdit[ item ] = true;
	}

	$scope.hoverEditLeave = function ( item ) {
		$scope.hoverEdit[ item ] = false;
	}
});

portalapp.controller("Portal_CreateView_Component",function( $scope, module, $modalInstance, api, webapp, language, $translatePartialLoader, $filter, $http, editStatus,record, fromRelatedList) {
	/*@ngInject*/
    $scope.data = {};
	$scope.datemodel = {};
	$scope.timemodel = {};
	$scope.minDates = [];
	$scope.structure = null;
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
	var availableModules = JSON.parse( localStorage.getItem( 'modules' ) );
	var profileModules = JSON.parse( localStorage.getItem('profileModules'));
	if(profileModules.hasOwnProperty(module)) {
		angular.extend(availableModules, profileModules);
	}
	$scope.moduleUiLabel = availableModules[ module ].uiLabel;

	if ( $translatePartialLoader !== undefined ) {
		$translatePartialLoader.addPart( 'home' );
		$translatePartialLoader.addPart( module );
	}

	function splitFields( arr, size ) {
		var newArr = [];
		for ( var i = 0; i < arr.length; i += size ) {
			newArr.push( arr.slice( i, i + size ) );
		}
		return newArr;
	}
	$scope.openDatePicker = function ( $event, elementOpened ) {
		$event.preventDefault();
		$event.stopPropagation();
		$scope.datemodel[ elementOpened ] = !$scope.datemodel[ elementOpened ];
	};

	$scope.openTimePicker = function ( $event, elementOpened ) {
		$event.preventDefault();
		$event.stopPropagation();
		$scope.timemodel[ elementOpened ] = !$scope.timemodel[ elementOpened ];
	};
	// Disable weekend selection
	$scope.disabled = function ( date, mode ) {
		return ( mode === 'day' && ( date.getDay() === 0 || date.getDay() === 6 ) );
	};

	$scope.minDate = new Date();

	if ( !editStatus ) {
		api.getDescribe( module , {
				language: language
			} )
			.success( function ( structure ) {
				var editables = [];
				var editablesText = [];
				$scope.timeLabels = [];
				$scope.multipicklistFields = [];
				$scope.referenceFields = [];
				$scope.nonAvailableReferenceFields = [];
				$scope.descriptionEnabled = false;
				$scope.avaliableFields = [];
				var labelField = structure.describe.labelFields;
                $scope.labelField = labelField;
				angular.forEach( structure.describe.fields, function ( field ) {
					if ( field.name !== 'contact_id' && field.name !== 'parent_id' && field.name !== 'assigned_user_id' && field.name !== 'related_to' && field.editable && field.type.name !== "text" ) {
						if ( field.type.name == 'string' && field.editable ) {
							$scope.data[ field.name ] = field.default;
							if ( field.name == labelField ) {
								$scope.recordTitleLabel = field.label;
								$scope.data[ labelField ] = field.default;
							}
						}
                        
						if ( field.type.name == 'integer' && field.editable ) {

							$scope.data[ field.name ] = field.default;

						}

						if ( field.type.name == 'phone' || field.type.name == 'skype' && field.editable ) {
							$scope.data[ field.name ] = field.default;
						}

						if ( field.type.name == 'boolean' && field.editable ) {
							if ( field.default == "on" ) {
								$scope.data[ field.name ] = true;
							} else {
								$scope.data[ field.name ] = false;
							}
						}

						if ( field.type.name == 'email' && field.editable ) {
							$scope.data[ field.name ] = field.default;
						}

						if ( field.type.name == 'url' && field.editable ) {
							$scope.data[ field.name ] = field.default;
						}

						if ( field.type.name == 'double' && field.editable ) {
							$scope.data[ field.name ] = field.default;
						}

						if ( (field.type.name == 'currency' || field.type.name == 'multicurrency') && field.editable ) {
							$scope.data[ field.name ] = field.default;
						}

						if ( field.type.name == 'time' && field.editable ) {
							var date = new Date();
							$scope.timeField = true;
							$scope.timeLabels.push( field.name );
							if ( field.default !== '' ) {
								var defaultTime = field.default.split( ':' );
								date.setHours( defaultTime[ 0 ] );
								date.setMinutes( defaultTime[ 1 ] );
								$scope.data[ field.name ] = date;
							} else {
								$scope.data[ field.name ] = date;
							}
						}
						if ( (field.type.name == 'date' || field.type.name == 'anniversary') && field.editable ) {
							if ( !isNaN( field.default ) ) {
								var date = new Date();
								$scope.data[ field.name ] = $filter( 'date' )( date, "yyyy-MM-dd" );
								var minDate = $filter( 'date' )( date, "yyyy-MM-dd" );
								$scope.minDates.push( field.name );
								$scope.minDates[ field.name ] = minDate;
							} else {
								$scope.data[ field.name ] = $filter( 'date' )( field.default, "yyyy-MM-dd" );
								var minDate = $filter( 'date' )( field.default, "yyyy-MM-dd" );
								$scope.minDates.push( field.name );
								$scope.minDates[ field.name ] = minDate;
							}
						}

						if ( field.type.name == 'multipicklist' && field.editable ) {
							$scope.multipicklistFields.push( field.name );
							var defaultValues = [];
							if ( field.default !== null ) {
								defaultValues = field.default.split( ' |##| ' );
							}
							var selectedValues = [];
							if ( defaultValues.length !== 0 ) {
								angular.forEach( defaultValues, function ( values, i ) {
									if(defaultValues[i] !== ''){
									o.label = defaultValues[i];
									o.value = defaultValues[i];
									selectedValues.push(o);
								}
								} );
							}
							$scope.data[ field.name ] = selectedValues;
						}

						if ( (field.type.name == 'picklist' || field.type.name == 'metricpicklist' || field.type.name == 'radio') && field.editable ) {
							var continueLoop = true;
							var defaultValue = field.default;
							angular.forEach( field.type.picklistValues, function ( pickList, i ) {
								if ( continueLoop ) {
									if ( defaultValue !== '' && pickList.value == defaultValue ) {
										field.value = field.type.picklistValues[ i ];
										field.index = i;
										continueLoop = false;
									} else if ( defaultValue === '' ) {
										field.value = field.type.picklistValues[ i ];
										field.defaultIndex = i;
										continueLoop = false;
									}
								}
							} );
							if ( field.index === undefined ) {
								$scope.data[ field.name ] = '';
							} else {
								$scope.data[ field.name ] = field.type.picklistValues[ field.index ].value;
							}
							$scope.avaliableFields[field.name] = field.type.picklistValues;
						}
						if ( field.name !== labelField ) {
							editables.push( field )
						}
					}
					if ( field.type.name === "text" && field.editable ) {
						$scope.data[ field.name ] = field.default;
						editablesText.push( field );
					}
				} );
				$scope.picklistDependency = structure.describe.picklistDependencyDataSource;
				var newEditables = [];
				angular.forEach( editables, function ( field, i ) {
					var isDeleted = false;
					if ( field.type.name === "reference" ) {
						if ( field.type.refersTo[ 0 ] === undefined || availableModules[ field.type.refersTo[ 0 ] ] === undefined ) {
							isDeleted = true;
						}
					}
					if ( !isDeleted ) {
						if ( field.type.name === "reference" ) {
							$scope.referenceFields.push( field.name );
						}
						newEditables.push( field );
					}
				} );
				editables = newEditables;
				$scope.fields = splitFields( editables, 2 );
				if ( editablesText.length !== 0 ) {
					$scope.textFieldsEnabled = true;
					$scope.editableText = editablesText;
				}
			} );
	}

	$scope.fetchReferenceRecords = function ( module, query ) {
		var records = [];
		return $http.get( 'index.php?module=' + module + '&api=FetchReferenceRecords', {
				params: {
					module: module,
					query: query
				}
			} )
			.then( function ( response ) {
				angular.forEach( response.data.result, function ( record, i ) {
					if ( angular.isObject( record ) ) {
						records.push( response.data.result[ i ] );
					}
				} )
				return records;
			} );
	}

	$scope.save = function ( validity, dateFilter ) {
		if ( !validity ) {
			$scope.submit = true;
			return false;
		}
		if ( $scope.referenceFields.length > 0 ) {
			angular.forEach( $scope.referenceFields, function ( label ) {
				if ( $scope.data[ label ] !== undefined && $scope.data[ label ] !== '' ) {
					$scope.data[ label ] = $scope.data[ label ].id;
				} else {
					$scope.data[ label ] = '';
				}
			} );
		}
        
		if ( $scope.nonAvailableReferenceFields.length > 0 ) {
			angular.forEach( $scope.nonAvailableReferenceFields, function ( label ) {
				if ( $scope.data[ label ] !== undefined && $scope.data[ label ] !== '' ) {
					$scope.data[ label ] = $scope.data[ label ].value;
				} else {
					$scope.data[ label ] = '';
				}
			} );
		}

		if ( $scope.multipicklistFields.length !== 0 ) {
			angular.forEach( $scope.multipicklistFields, function ( label ) {
				var choosenValues = $scope.data[ label ];
				var transformedValues = [];
				angular.forEach( choosenValues, function ( values, i ) {
					if ( values.value !== '' )
						transformedValues.push( values.value )
				} );
				$scope.data[ label ] = '';
				if ( transformedValues.length > 0 ) {
					$scope.data[ label ] = transformedValues;
				}
			} );
		}

		if ( $scope.timeField ) {
			angular.forEach( $scope.timeLabels, function ( label ) {
				var convertedTime = $filter( 'date' )( $scope.data[ label ], "HH:mm A" );
				$scope.data[ label ] = convertedTime;
			} )
		}
		webapp.busy();
		if ( $scope.data[ 'serviceid' ] !== undefined ) {
			$scope.data[ 'serviceid' ] = $scope.data[ 'serviceid' ].id;
		}
		var params = {
			record: $scope.data
		}
		if ( editStatus ) params.recordId = $scope.editRecord.id;
		$modalInstance.close( $scope.data );
		api.post( module + '/SaveRecord', params )
			.success( function ( savedRecord ) {
				webapp.busy( false );
				$modalInstance.dismiss( 'cancel' );
				if ( savedRecord.record !== undefined ) {
                    if(fromRelatedList) {
                        window.location.reload();
                        return true;
                    }
                    
					var id = savedRecord.record.id.split( 'x' );
					var url = 'index.php?module=' + module + '&view=Detail&id=' + savedRecord.record.id;
					if(profileModules.hasOwnProperty(module)) {
						url = 'index.php?module=PortalProfile&view=MyProfile';
					}
					window.location.href = url;
				}
				if ( savedRecord.record === undefined ) {
					alert( savedRecord.message );
				}
			} );
	}

	$scope.cancel = function () {
		$modalInstance.dismiss( 'cancel' );
	}

	if ( editStatus ) {
		var editFields = [];
		var editableTextFields = [];
		$scope.referenceFields = [];
		$scope.nonAvailableReferenceFields = [];
		$scope.multipicklistFields = [];
		$scope.timeLabels = [];
		$scope.editRecord = angular.copy( record );
		$scope.header = record.identifierName.label;
		$scope.modalTitle = record[ $scope.header ];
		$scope.disabledFields = [];
		$scope.avaliableFields = [];
		api.getDescribe( module )
			.success( function ( describe ) {
				var editableFields = describe.describe.fields;
				var labelField = (module == 'Contacts') ? '' : describe.describe.labelFields;
				$scope.labelField = labelField;
				$scope.editRecord.labelField = labelField;
				$scope.modalTitle = record[ $scope.header ];
				angular.forEach( editableFields, function ( field ) {
					//If not editable push the field to disabledFields
					if ( !field.editable ) {
						$scope.disabledFields.push( field.name );
						$scope.disabledFields[ field.name ] = true;
					}
					if ( field.name !== 'contact_id' && field.name !== 'parent_id' && field.name !== 'assigned_user_id' && field.name !== 'related_to' && field.type.name !== 'text' && field.editable ) {
                        if ( field.type.name == 'string' ) {
							if ( field.name == labelField ) {
								$scope.recordTitleLabel = field.label;
								$scope.data[ $scope.labelField ] = record[ field.label ];
							}
							if ( field.name == 'serialnumber' ) {
								$scope.disabledFields.push( field.name );
								$scope.disabledFields[ field.name ] = true;
							}
							if ( record[ field.label ] === '' ) {
								$scope.data[ field.name ] = field.default;
							} else {
								$scope.data[ field.name ] = record[ field.label ];
							}
						}

						if ( field.type.name == 'integer' ) {
							if ( record[ field.label ] === '' ) {
								$scope.data[ field.name ] = field.default;
							} else {
								$scope.data[ field.name ] = record[ field.label ];
							}
						}

						if ( field.type.name == 'phone' || field.type.name == 'skype' ) {
							if ( record[ field.label ] === '' ) {
								$scope.data[ field.name ] = field.default;
							} else {
								$scope.data[ field.name ] = record[ field.label ];
							}
						}

						if ( field.type.name == 'boolean' ) {
							if ( record[ field.label ] === '' ) {
								$scope.data[ field.name ] = false;
							}
							if ( record[ field.label ] == "Yes" || field.default == "on" ) {
								$scope.data[ field.name ] = true;
							} else {
								$scope.data[ field.name ] = false;
							}
						}

						if ( field.type.name == 'email' ) {
							if ( record[ field.label ] === '' ) {
								$scope.data[ field.name ] = field.default;
							} else {
								$scope.data[ field.name ] = record[ field.label ];
							}
						}

						if ( field.type.name == 'url' ) {
							if ( record[ field.label ] === '' ) {
								$scope.data[ field.name ] = field.default;
							} else {
								$scope.data[ field.name ] = record[ field.label ];
							}
						}

						if ( field.type.name == 'reference' ) {
							if ( record[ field.label ] === '' || record[ field.label ] === 0 ) {
								$scope.data[ field.name ] = '';
							} else {

								if ( field.name === 'account' || field.name === 'contact' ) {
									$scope.disabledFields.push( field.name );
									$scope.disabledFields[ field.name ] = true;
								}
								if ( field.name === 'product' && module === 'Assets' ) {
									$scope.disabledFields.push( field.name );
									$scope.disabledFields[ field.name ] = true;
								}
								$scope.data[ field.name ] = record.referenceFields[ field.label ];
							}
						}

						if ( field.type.name == 'double' ) {
							if ( record[ field.label ] === '' ) {
								$scope.data[ field.name ] = field.default;
							} else {
								$scope.data[ field.name ] = record[ field.label ];
							}
						}

						if ( field.type.name == 'currency' || field.type.name == 'multicurrency' ) {
							if ( record[ field.label ] === '' ) {
								$scope.data[ field.name ] = field.default;
							} else {
								$scope.data[ field.name ] = record[ field.label ];
							}
						}

						if ( field.type.name == 'picklist' || field.type.name == 'metricpicklist' || field.type.name == 'radio' ) {
							var continueLoop = true;
							var defaultValue = field.default;
							angular.forEach( field.type.picklistValues, function ( pickList, i ) {
								if ( continueLoop ) {
									if ( pickList.label == record[ field.label ] && record[ field.label ] !== '' ) {
										field.value = field.type.picklistValues[ i ];
										field.index = i;
										continueLoop = false;
									} else if ( record[ field.label ] == '' && pickList.value == defaultValue ) {
										field.value = field.type.picklistValues[ i ];
										field.index = i;
										continueLoop = false;
									}
								}
							} );
							
                            if(field.type.picklistValues.length > 0 && record[ field.label ] === '') {
                                 $scope.data[ field.name ] = '';
                            } else if ( field.index !== undefined ) {
								$scope.data[ field.name ] = field.type.picklistValues[ field.index ].value;
							}
							$scope.avaliableFields[field.name] = field.type.picklistValues;
						}

						if ( field.type.name == 'multipicklist' ) {
							$scope.multipicklistFields.push( field.name );
							var defaultValues = [];
							var recordValues = record[ field.label ].split( ',' );
							if ( field.default !== null ) {
								defaultValues = field.default.split( ' |##| ' );
							}
							var selectedValues = [];
							if ( recordValues.length > 0 && recordValues[ 0 ] !== '' ) {
								angular.forEach( recordValues, function ( values, i ) {
									var o = {};
									o.label = values;
									o.value = values;
									selectedValues.push( o );
								} );
							} else if ( ( recordValues.length > 0 || recordValues[ 0 ] !== '' ) && defaultValues.length > 0 ) {
								angular.forEach( defaultValues, function ( values, i ) {
									var o = {};
									o.label = values;
									o.value = values;
									selectedValues.push( o );
								} );
							}
							$scope.data[ field.name ] = selectedValues;
						}

						if ( field.type.name == 'date' || field.type.name == 'anniversary' ) {
							if ( field.name === 'datesold' && module === 'Assets' ) {
								$scope.disabledFields.push( field.name );
								$scope.disabledFields[ field.name ] = true;
							}
							if ( record[ field.label ] === '' && !isNaN( field.default ) ) {
								var date = new Date();
								$scope.data[ field.name ] = $filter( 'date' )( date, "yyyy-MM-dd" );
								var minDate = $filter( 'date' )( record[ field.label ], "yyyy-MM-dd" );
								$scope.minDates.push( field.name );
								$scope.minDates[ field.name ] = minDate;
							} else if ( record[ field.label ] === '' && isNaN( field.default ) ) {
								$scope.data[ field.name ] = $filter( 'date' )( field.default, "yyyy-MM-dd" );
								var minDate = $filter( 'date' )( field.default, "yyyy-MM-dd" );
								$scope.minDates.push( field.name );
								$scope.minDates[ field.name ] = minDate;
							} else {
								$scope.data[ field.name ] = $filter( 'date' )( record[ field.label ], "yyyy-MM-dd" );
								var minDate = $filter( 'date' )( record[ field.label ], "yyyy-MM-dd" );
								$scope.minDates.push( field.name );
								$scope.minDates[ field.name ] = minDate;
							}
						}

						if ( field.type.name == 'time' ) {
							var date = new Date();
							$scope.timeField = true;
							$scope.timeLabels.push( field.name );
							if ( record[ field.label ] !== '' ) {
								var selectedTime = record[ field.label ].split( ':' );
								date.setHours( selectedTime[ 0 ] );
								date.setMinutes( selectedTime[ 1 ] );
								$scope.data[ field.name ] = date;
							} else if ( field.default !== '' ) {
								var defaultTime = field.default.split( ':' );
								date.setHours( defaultTime[ 0 ] );
								date.setMinutes( defaultTime[ 1 ] );
								$scope.data[ field.name ] = date;
							} else {
								$scope.data[ field.name ] = date;
							}
						}
						if ( field.name !== labelField ) {
							editFields.push( field )
						}
					}
					if ( field.type.name === "text" && field.editable) {
						editableTextFields.push( field );
						if ( record[ field.label ] !== '' ) {
							$scope.data[ field.name ] = record[ field.label ];
						} else {
							$scope.data[ field.name ] = field.default;
						}
					}
				} );
                
				$scope.picklistDependency = describe.describe.picklistDependencyDataSource;
				var newEditFields = [];
				angular.forEach( editFields, function ( field, i ) {
					var isDeleted = false;
					if ( field.type.name === "reference" ) {
						if ( field.type.refersTo[ 0 ] === undefined || availableModules[ field.type.refersTo[ 0 ] ] === undefined ) {
							isDeleted = true;
						}
					}
					if ( !isDeleted ) {
						if ( field.type.name === "reference" ) {
							$scope.referenceFields.push( field.name );
						}
						newEditFields.push( field );
					}
					if (field.type.name==='reference' && availableModules[ field.type.refersTo[ 0 ] ] === undefined ){
						$scope.nonAvailableReferenceFields.push(field.name);
					}
				} );
				editFields = newEditFields;

				$scope.fields = splitFields( editFields, 2 );
				if ( editableTextFields.length !== 0 ) {
					$scope.textFieldsEnabled = true;
					$scope.editableText = editableTextFields;
				}
			} )
	}

	/**
	 * Function to get the picklist dependency values, if picklist dependency is disable then default values are used.
	 * @param object picklistDependency
	 * @param string picklistName
	 * @param string/empty selectedValue
	 * @return array of object
	 */
	$scope.getDependentPicklistValues = function(picklistDependency,picklistName,selectedValue){
		//using copy to get a immutable default copy of dependency datasource
		var dependentPicklistValues = angular.copy(picklistDependency[picklistName]['__DEFAULT__']);
		var configuredPicklistValues = picklistDependency[picklistName][selectedValue];
		for(var configuredPicklist in configuredPicklistValues){
			dependentPicklistValues[configuredPicklist] = configuredPicklistValues[configuredPicklist];
		}
		return dependentPicklistValues;
	}

	/**
	 * Function to get the allowed dependent values, ex roled based picklist
	 * @param object dependentPicklistValues
	 * @param string targetPicklist
	 * @return Array
	 */
	$scope.getAllowedPicklistValues = function(dependentPicklistValues,targetPicklist){
		var matches = [];	
		var avaliableFields = $scope.avaliableFields[targetPicklist];
		var dependentTargetValues = dependentPicklistValues[targetPicklist];
		for (var i = 0; i < avaliableFields.length; i++) {
			for (var j = 0; j < dependentTargetValues.length; j++) {
				if (avaliableFields[i].value === dependentTargetValues[j].value){
					matches.push(avaliableFields[i]);
					continue;
				}
			}
		}
		return matches;
	}

	/**
	 * function to change the target model.
	 * @param string matches
	 * @param string targetPicklist
	 */
	$scope.setModel = function(matches,targetPicklist){
		var isSelectedValueExistsInDependency = ($filter('filter')(matches,$scope.data[targetPicklist])).length;
		if(!isSelectedValueExistsInDependency || $scope.data[targetPicklist] == ''){
			$scope.data[targetPicklist] = '';
			if(matches.length){
				$scope.data[targetPicklist] = matches[0].value;
			}
		}
	}

	/**
	 * function to handle picklist dependency
	 * @param object picklistDependency
	 * @param string picklistName
	 * @param string selectedValue
	 * @return bool
	 */
	$scope.picklistDependencyHandler = function(picklistDependency,picklistName,selectedValue){
		if(typeof(picklistDependency) != 'undefined' && picklistDependency && picklistDependency.hasOwnProperty(picklistName)){
			var dependentPicklistValues = $scope.getDependentPicklistValues(picklistDependency,picklistName,selectedValue);
			for (var targetPicklist in dependentPicklistValues) {
				for(var row in this.fields){
					for(var element in this.fields[row]){
						if($scope.fields[row][element].name == targetPicklist){
							var avaliableFields = $scope.avaliableFields[targetPicklist];
							$scope.fields[row][element].type.picklistValues = avaliableFields;
							if(selectedValue != ''){
								var matches = $scope.getAllowedPicklistValues(dependentPicklistValues,targetPicklist);
								$scope.fields[row][element].type.picklistValues = matches;
								$scope.setModel(matches,targetPicklist);
								$scope.picklistDependencyHandler(picklistDependency,targetPicklist,$scope.data[targetPicklist]);
							}
						}
					}
				}
			}
		}
		return true
	}

});

portalapp.controller("Portal_FilterView_Component",function( $scope, module, $modalInstance, api, webapp, language, $cache) {
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
    api.getDescribe(module).success( function (describe) {
        var data = {};
        var filterFieldsInfo = describe.describe.filterFieldsInfo;
        var fields = describe.describe.fields;
        angular.forEach(filterFieldsInfo, function(values, fieldName) {
            angular.forEach(fields, function(field, index) {
                if(field.name == fieldName) {
                    var filterPicklistValues = [];
                    var picklistValues = field.type.picklistValues;
                    angular.forEach(values, function(value, index) {
                        angular.forEach(picklistValues, function(picklistValue, index) {
                            if(picklistValue.value == value) {
                                filterPicklistValues.push(picklistValue);
                            }
                        });
                    });
                    if(filterPicklistValues && filterPicklistValues.length) {
                        data[fieldName] = {fieldLabel: field.label, 'picklistValues': filterPicklistValues};
                    }
                    return false;
                }
            });
        });
        
        var selectedFieldsInfo = $scope.getAppliedFilters();
        angular.forEach(selectedFieldsInfo, function(values, fieldName) {
            angular.forEach(fields, function(field, index) {
                if(field.name == fieldName) {
                    var selectedPicklistValues = [];
                    var picklistValues = field.type.picklistValues;
                    angular.forEach(values, function(value, index) {
                        angular.forEach(picklistValues, function(picklistValue, index) {
                            if(picklistValue.value == value) {
                                selectedPicklistValues.push(picklistValue);
                            }
                        });
                    });
                    if(selectedPicklistValues.length) {
                        data[fieldName]['selectedPicklistValues'] = selectedPicklistValues;
                    }
                    return false;
                }
            });
        });
        
        $scope.filterFieldsInfo = data;
    });
    
    $scope.getAppliedFilters = function() {
        return $cache.get($scope.module + '_filter_fields');
    },
    
    $scope.applyFilter = function() {
        var filterFieldsInfo = $scope.filterFieldsInfo;
        var selectedFilterFields = {};
        angular.forEach(filterFieldsInfo, function(fieldInfo, fieldName) {
            var selectedPicklistValues = fieldInfo.selectedPicklistValues;
            var picklistValues = [];
            angular.forEach(selectedPicklistValues, function(selectedPicklistValue, index) {
                picklistValues.push(selectedPicklistValue.value);
            });
            if(picklistValues.length) {
                selectedFilterFields[fieldName] = picklistValues;
            }
        });
        localStorage.setItem($scope.module + '_filter_fields', JSON.stringify(selectedFilterFields));
        $scope.$emit('cp::filter::updated');
        
        $modalInstance.dismiss( 'cancel' );
        $scope.loadRecords();
    }
    
    $scope.cancel = function () {
        $modalInstance.dismiss('cancel');
    }
});

portalapp.controller("Portal_Related_FilterView_Component", function( $scope, module, $modalInstance, api, webapp, language, $controller, $cache){
    $controller("Portal_FilterView_Component", {$scope, module, $modalInstance, api, webapp, language});
    
    $scope.relatedModule = module;
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
    $scope.getAppliedFilters = function() {
        var parentModule = $scope.module;
        var relatedModule = $scope.relatedModule;
        var key = parentModule+"_"+relatedModule+"_filter_fields";
        return $cache.get(key);
    }
    
    $scope.applyFilter = function() {
        var parentModule = $scope.module;
        var relatedModule = $scope.relatedModule;
        
        var filterFieldsInfo = $scope.filterFieldsInfo;
        var selectedFilterFields = {};
        angular.forEach(filterFieldsInfo, function(fieldInfo, fieldName) {
            var selectedPicklistValues = fieldInfo.selectedPicklistValues;
            var picklistValues = [];
            angular.forEach(selectedPicklistValues, function(selectedPicklistValue, index) {
                picklistValues.push(selectedPicklistValue.value);
            });
            if(picklistValues.length) {
                selectedFilterFields[fieldName] = picklistValues;
            }
        });
         
        var key = parentModule+"_"+relatedModule+"_filter_fields";
        $cache.set(key, selectedFilterFields);
        $scope.$emit('cp::related::filter::updated', relatedModule);
        
        $modalInstance.dismiss( 'cancel' );
        
        var moduleLabel = (relatedModule == 'Calendar') ? 'Tasks' : relatedModule;
        var handlerName = 'load'+moduleLabel;
        if($scope[handlerName]) {
            $scope[handlerName]();
        }
        $scope.searchApplied = true;
    }
    
});

portalapp.controller("Portal_RelatedEditView_Component",function( $scope, module, record, parentId, language, parentScope, $modal, $api, $webapp ) {
    $scope = angular.extend({}, $scope);
    
    // If parentId is not set then server will check the relation with Contact/ORG, if not exist then throws error
    $scope.parentId = parentId;
    parentScope.fetchRecord(module, record, {scope : $scope, fromRelatedList : true}).success(function(response){
        if(response.error) {
            alert('Record is not editable');
            return true;
        }
        
        $scope.module = module;
        $scope.language = language;
        $modal.open({
            templateUrl: "editRecordModal.template",
            controller: 'Portal_CreateView_Component',
            backdrop: "static",
            size: "lg",
            resolve: {
                module: function () {
                    return $scope.module;
                },
                record: function () {
                    return $scope.record;
                },
                fromRelatedList : function() {
                    return true;
                },
                editStatus: function () {
                    return true;
                },
                api: function () {
                    return $api;
                },
                webapp: function () {
                    return $webapp;
                },
                language: function () {
                    return $scope.language;
                }
            },
        });
    });
});

portalapp.controller("Portal_FilePreview_Component",function( $scope, $modalInstance, $api, record, module) {
    $scope.file_type = record.filetype;
    $scope.file_url = record['file_url'];
    if(record.filetype === 'application/pdf') { 
        var url = encodeURIComponent(record['file_url']);
        // We are not including separate library in portal. Reusing from instance library folder
        $scope.file_url = "../libraries/jquery/pdfjs/web/viewer.html?file="+url+"";
    }
    
    setTimeout(function() {
        // We don't want download option from pdf viewer
        jQuery('iframe[name="filePreview"]').contents().find('#secondaryDownload, #secondaryOpenFile, #secondaryPrint, .print, .download').css("display", "none");
        
        // removing context menu for pdf files to avoid download option from there, since is download is controlled from settings
        jQuery('iframe[name="filePreview"]').contents().find('body').attr('oncontextmenu', 'return false;');
    }, 200);
    
    $api.getDescribe( module ).success( function ( describe ) {
        var editableFields = describe.describe.fields;
        var labelField = (module === 'Contacts') ? '' : describe.describe.labelFields;
        angular.forEach( editableFields, function ( field ) {
            if(field.name === labelField) {
                $scope.modalHeaderTitle = record[field.label];
            }
        });
    });
    
    $scope.cancel = function () {
		$modalInstance.dismiss( 'cancel' );
	}
});