<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

include_once 'vtlib/Vtiger/Net/Client.php';

abstract class Vtiger_PortalBase_Connector extends Vtiger_Connector {

    protected $client;
    protected $auth;

    protected function __construct() {
        $this->client = new Vtiger_Net_Client(Portal_Config::get('crm.url'));
    }

    protected function api($params) {
        if ($this->client) {
            $this->client->setHeaders($this->auth);
            $response = $this->client->doPost($params);
            // echo '<pre>'.'save api1';print_r($response);
            $responseText = json_decode($response, true);
            // echo '<pre>'.'save api2';print_r($responseText);
            if ($responseText['success'] && $responseText['result']) {
                return $responseText['result'];
            } else {
                return $responseText['error'];
            }
            throw new Exception('Invalid Request');
        }
    }

}

class Vtiger_Portal_Connector extends Vtiger_PortalBase_Connector {

    public function isAuthenticated() {
        $this->auth = Portal_Session::get('portal_auth', null);
        return $this->auth != null;
    }

    public function ping($username, $password) {
        $this->auth = array('Authorization' => 'Basic ' . base64_encode($username . ':' . $password));
        $args = array(
            '_operation' => 'Ping',
            'username' => $username,
            'password' => $password
        );
        return self::api($args);
    }

    public function authentication() {
        if ($this->isAuthenticated()) {
            $authInfo = explode(':', base64_decode(substr($this->auth['Authorization'], strlen('Basic '))));
            array_pop($authInfo); // NOTE: password removed.
            $authInfo['username'] = $authInfo;
            return $authInfo;
        }
        return null;
    }

    public function fetchModules($username = false, $password = false,$language=false) {
        if($language=='')$language = Portal_Session::get('language');
        $args = array(
            '_operation' => 'FetchModules',
            'language'=>$language
        );

        if ($username && $password) {
            $args['username'] = $username;
            $args['password'] = $password;
            $this->auth = array('Authorization' => 'Basic ' . base64_encode($username . ':' . $password));
        }


        $response = self::api($args);

        if (isset($response['contact_id']) && isset($response['contact_id']) && isset($response['contact_id'])) {
            if ($username && $password && $response) {
                Portal_Session::set('portal_auth', $this->auth);
                $availableLanguages =  Portal_Config::get('languages');
                $languageAvailable = false;
                foreach ($availableLanguages as $portalLanguage) {
                    if($portalLanguage['value'] == $response['language']) {
                        $languageAvailable = true; break;
                    }
                }
                if($languageAvailable) {
                    Portal_Session::set('language', $response['language']);
                } else {
                    $defaultLanguage = Portal_Config::get('ui.Language');
                    Portal_Session::set('language', $defaultLanguage['value']);
                }
                Portal_Session::set('contact_id', $response['contact_id']['value']);
                Portal_Session::set('parent_id', $response['account_id']['value']);
                Portal_Session::set('parent_idLabel',$response['sccount_id']['label']);
                Portal_Session::set('assigned_user_id', $response['user_id']['value']);
				Portal_Session::set('owner_date_format', $response['owner_date_format']);
				Portal_Session::set('owner_hour_format', $response['owner_hour_format']);
            }
        } else {
            return null;
        }
        return $response;
    }

    public function describeModule($module,$language) {
        $language = Portal_Session::get('language');
        $params = array(
            '_operation' => 'DescribeModule',
            'module' => $module,
            'language'=>$language
        );

        $response = self::api($params);

        return $response;
    }

    public function fetchRecords($module, $label, $q = false, $filter = false, $pageNo = false, $pageLimit = false,$orderBy=false,$order=false) {
        $params = array(
            '_operation' => 'FetchRecords',
            'module' => $module,
            'moduleLabel' => $label,
            'page' => $pageNo,
            'pageLimit' => $pageLimit,
            'fields' => $filter,
            'orderBy'=>$orderField,
            'order'=>$order
        );
        if ($q) {
            $params = array_merge($params, $q);
        }
        $response = self::api($params);
        return $this->parseListViewRecords($response, $module);
    }

    public function fetchRelatedRecords($relatedModule, $relatedModuleLabel, $id, $parentId, $pageNo, $pageLimit,$module=false,$filter = array(), $roll_up_to = false) {
        $params = array(
            '_operation' => 'FetchRelatedRecords',
            'relatedModule' => $relatedModule,
            'relatedModuleLabel' => $relatedModuleLabel,
            'recordId' => $id,
            'parentId' => $parentId,
            'page' => $pageNo,
            'pageLimit' => $pageLimit,
            'module'=>$module,
            'filter' => $filter,
            'roll_up_to' => $roll_up_to
        );
        $response = self::api($params);
        return $response;
    }
    
    /**
     * To fetch record by count (Right now, We are using this to show summary in Project detail view)
     * @param module -> which module you want to get count for
     * @param groupby -> count grouping by which field
     * @param filter -> any extra conditions to apply (reference field can be set to get related records)
     */
    public function fetchRecordsCountByField($module, $groupby, $filter) {
        $params = array(
            '_operation' => 'FetchRecordsCountByField',
            'module'=>$module,
            'groupby' => $groupby,
            'filter' => $filter
        );
        $response = self::api($params);
        return $response;
    }

    public function fetchRecord($id, $parentId = false, $module, $selectedMode = false) {
        $params = array(
            '_operation' => 'FetchRecord',
            'module' => $module,
            'recordId' => $id,
            'parentId' => $parentId,
			'selectedMode' => $selectedMode	
        );
        $response = self::api($params);
        return $response;
    }

    public function fetchHistory($module, $id, $pageNo, $pageLimit,$parentId=false, $selectedMode = false, $roll_up_to = false) {
        $params = array(
            '_operation' => 'FetchHistory',
            'record' => $id,
            'module' => $module,
            'page' => $pageNo,
            'pageLimit' => $pageLimit,
            'parentId'=>$parentId,
			'selectedMode' => $selectedMode,
            'roll_up_to' => $roll_up_to
        );
        $response = self::api($params);
        return $response;
    }

    public function saveRecord($module, $values, $recordId = false) {

        $params = array(
            '_operation' => 'SaveRecord',
            'module' => $module,
            'values' => $values
        );

        if ($recordId) {
            $params['recordId'] = $recordId;
        }

        $response = self::api($params);
        if(is_array($response) && $module=='Contacts' && !(empty($response['record']['email']))){
          $authInfo = explode(':', base64_decode(substr($this->auth['Authorization'], strlen('Basic '))));
          $this->auth = array('Authorization' => 'Basic '.base64_encode($response['record']['email'].':'.$authInfo[1]));
          // After contact module save if language is modified then set updated language in portal session 
          if(Portal_Session::get('language') != $response['record']['language']) {
              $newLanguage = $response['record']['language'];
              $availableLanguages =  Portal_Config::get('languages');
                $languageAvailable = false;
                foreach ($availableLanguages as $portalLanguage) {
                    if($portalLanguage['value'] == $newLanguage) {
                        $languageAvailable = true; break;
                    }
                }
                if($languageAvailable) {
                    Portal_Session::set('language', $newLanguage);
                } else {
                    $defaultLanguage = Portal_Config::get('ui.Language');
                    Portal_Session::set('language', $defaultLanguage['value']);
                }
          }
          Portal_Session::set('portal_auth', $this->auth);
        }
        return $response;
    }

    public function addComment($values, $parentId) {
        $params = array(
            '_operation' => 'AddComment',
            'values' => $values,
            'parentId' => $parentId
        );
        $response = self::api($params);
        return $response;
    }

    public function downloadFile($module, $q,$parentId=false, $parentModule = false,$attachmentId=false) {
        $params = array(
            '_operation' => 'DownloadFile',
            'module' => $module,
            'moduleLabel' => $module,
            'recordId' => $q,
            'parentId' => $parentId,
            'parentModule' => $parentModule,
			'attachmentId'=> $attachmentId,
        );
        return self::api($params);
    }

    public function changePassword($record) {
        $params = array(
            '_operation' => 'ChangePassword',
            'password' => $record['oldPassword'],
            'newPassword' => $record['newPassword']
        );
        return self::api($params);
    }

    public function fetchProfile($modules) {
        $params = array(
            '_operation' => 'FetchProfile',
			'modules' => $modules
        );
        return self::api($params);
    }

    public function uploadAttachment($module,$parentId='') {
        $url = Portal_Config::get('crm.url');
        if (isset($_FILES)) {
            $authInfo = explode(':', base64_decode(substr($this->auth['Authorization'], strlen('Basic '))));
            $header = array('Content-Type:multipart/form-data');
            /**
             * CURLOPT_SAFE_UPLOAD, this is set to false by default in PHP 5.5 and is switched to a default of true in PHP 5.6.
             * This will prevent the '@' upload modifier from working for security reasons - user input could contain malicious upload requests.
             * You can use the CURLFile class to upload files while CURLOPT_SAFE_UPLOAD is set to true.
             * CURLFile class supported in both 5.6 and < 5.6 versions.
             */
            $curlFile = new CURLFile($_FILES['file']['tmp_name'], $_FILES['file']['type'], $_FILES['file']['name']);
            $data = array('file' => $curlFile,
                '_operation' => 'SaveRecord',
                'module' => $module,
                'parentId'=>$parentId,
                'filename' => $_FILES['file']['name']);
            if(isset($_FILES['file']['title'])) {
                $data['title'] = $_FILES['file']['title'];
            }
              //  echo '<pre>'.'curldata';print_r($data);
            $resource = curl_init();
            curl_setopt($resource, CURLOPT_URL, $url);
            curl_setopt($resource, CURLOPT_HTTPHEADER, $header);
            curl_setopt($resource, CURLOPT_USERPWD, $authInfo[0] . ":" . $authInfo[1]);
            curl_setopt($resource, CURLOPT_POST, 1);
            curl_setopt($resource, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($resource, CURLOPT_POSTFIELDS, $data);
            $response = curl_exec($resource);
            // echo '<pre>'.'curl resp';print_r($response);die;
            $info = curl_getinfo($resource);
            curl_close($resource);
            $responseText = json_decode($response, true);
            if ($responseText['success']) {
                return $responseText['result'];
            } else {
                return $responseText['error']['message'];
            }
        }
    }

    public function forgotPassword($email) {
        $params = array(
            '_operation' => 'ForgotPassword',
            'email' => $email
        );
        $this->auth = array('Authorization' => 'Basic ' . base64_encode($email . ':' . ''));
        $response = self::api($params);
        return $response;
    }

    public function fetchRelatedModules($module) {
        $params = array(
            '_operation' => 'FetchRelatedModules',
            'module' => $module
        );
        return self::api($params);
    }

    public function fetchAnnouncement() {
        $params = array(
            '_operation' => 'FetchAnnouncement'
        );
        $response = self::api($params);
        return $response;
    }

    public function fetchShortcuts() {
        $params = array(
            '_operation' => 'FetchShortcuts'
        );
        $response = self::api($params);
        return $response;
    }

    public function fetchRecentRecords($language) {
      $language = Portal_Session::get('language');
        $params = array(
            '_operation' => 'FetchRecentRecords',
            'language'=>$language
        );
        $response = self::api($params);
        return $response;
    }

    public function fetchSupportNotification() {
        $params = array(
            '_operation' => 'FetchSupportNotification'
        );
        $response = self::api($params);
        return $response;
    }

    public function fetchCharts($language=false) {
        $language = Portal_Session::get('language');
        $params = array(
            '_operation' => 'FetchCharts',
            'language'=>$language
        );
        $response = self::api($params);
        return $response;
    }


    public function fetchReferenceRecords($module,$query) {
        $params = array(
            '_operation' => 'FetchReferenceRecords',
            'module' => $module,
            'searchKey'=> $query
        );
        $response = self::api($params);
        return $response;
    }

    public function fetchCompanyDetails() {
        $params = array(
            '_operation' => 'FetchCompanyDetails',
        );
        $response = self::api($params);
        return $response;
    }

    public function exportRecords($module, $label, $q = false, $filter = false) {
        $params = array(
            '_operation' => 'ExportRecords',
            'module' => $module,
            'moduleLabel' => $label,
            'fields' => $filter
        );
        if ($q) {
            $params = array_merge($params, $q);
        }
        $response = self::api($params);
        return $response;
    }

    public function searchFaqs($module,$searchKey){
      $params = array(
          '_operation' => 'SearchFaqs',
          'module' => $module,
          'searchKey'=>$searchKey
      );
      $response = self::api($params);
      return $response;
    }

    public function searchRecords($searchKey){
      	$params = array (
	    	'_operation'=>'SearchRecords',
	    	'searchKey'=>$searchKey
	    );
	    $response = self::api($params);
	    return $response;
    }

    protected function parseListViewRecords($response, $module) {
      if($response['count']===null){
        return $response;
      }
        $edit = $headers = $records = array();
        for ($i = 0; $i < count($response) - 1; $i++) {
            if ($response[$i]) {
                $record = array();
                if (!is_array($response[$i]))
                    continue;
                foreach ($response[$i] as $field => $value) {
                    if ($i == 0) {
                        $headers[] = $field;
                        $edit[$field] = $field;
                    }
                    if (is_array($value)) {
                        $record[$field] = $value['label'];
                    } else {
                        $record[$field] = $value;
                    }
                }
            }
            $records[] = $record;
        }
        return array('headers' => $headers, 'records' => $records, 'edit' => $edit, 'count' => (int) $response['count']);
    }
    
        public function trackEngagement($status){
            $args = array(
                '_operation' => 'TrackEngagement',
                'status'=> $status,
            );
            return self::api($args);
        }
        
        public function fetchFaqCategoryCounts() {
            $params = array(
                '_operation' => 'FetchFaqCategoryCounts',
                'language' => Portal_Session::get('language')
            );
            $response = self::api($params);
            return $response;
        }
        
        public function fetchCustomThemeUrl() {
            $params = array(
                '_operation' => 'FetchCustomThemeUrl'
            );
            $this->auth = array('Authorization' => 'Basic ' . base64_encode('' . ':' . ''));
            $response = self::api($params);
            return $response;
        }
		
		public function fetchDefaultScopeFilter(){
			$params = array(
				'_operation' => 'FetchDefaultScopeFilter',
			);
			$this->auth = array('Authorization' => 'Basic ' . base64_encode('' . ':' . ''));
			$response = self::api($params);
			return $response;
		}
        
		public function fetchGreetingType() {
			$params = array(
				'_operation' => 'FetchGreetingType'
			);
			$response = self::api($params);
			return $response;
		}
		
		public function fetchAccountRepresentatives() {
			$params = array(
				'_operation' => 'FetchAccountRepresentatives'
			);
			$response = self::api($params);
			return $response;
		}
        
        public function loginFailure($param) {
            $params = array(
				'_operation' => 'LoginFailure',
                'action' =>  $param['action'],
                'username' => $param['username']
			);
            $response = self::api($params);
			return $response;            
        }        

}
