<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_FetchRelatedModules_API extends Portal_Default_API {

    public function process(Portal_Request $request) {
        $module = $request->getModule();
        $result = Vtiger_Connector::getInstance()->fetchRelatedModules($module);
        $response = new Portal_Response();
        $response->setResult($this->processResponse($result));
        return $response;
    }

    public function processResponse($result) {
        $activeModules = array();
        foreach ($result as $module => $values) {
            $activeModules[] = array('name' => $values, 'value' => 1);
        }
        return $activeModules;
    }

}
