<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_FetchRecentRecords_API extends Portal_Default_API {

    public function process(Portal_Request $request) {
        $response = new Portal_Response();
        $result = Vtiger_Connector::getInstance()->fetchRecentRecords($languge);
        $response->setResult($this->processRecentRecords($result));
        return $response;
    }

    public function processRecentRecords($result) {
        $recentRecords = array();
        foreach ($result as $key => $value) {
            foreach ($value as $module => $records) {
                foreach ($records as $labelid => $info) {
                    $records[$labelid]['label']=html_entity_decode($info['label'], ENT_QUOTES, 'utf-8');
                    $recentRecords['records'][$module][] = $records[$labelid];
                }
            }
        }
        return $recentRecords;
    }

}
