<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_FetchCharts_API extends Portal_Default_API {

    public function process(Portal_Request $request) {

        $response = new Portal_Response();
        $language = Portal_Session::get('language');
        $result = Vtiger_Connector::getInstance()->fetchCharts($language);
        $response->setResult($this->processCharts($result));
        return $response;
    }

    public function processCharts($result) {
        $enabledCharts = $result['charts'];
        $rows = array();
        $cols = array();
        $chartData = array();
        $countOfCharts = count($enabledCharts);
        $chartData['count'] = $countOfCharts;
        for ($i = 0; $i < count($enabledCharts);  ++$i) {
            $chartInfo = array();
            if(is_array($enabledCharts[$i])){
            foreach ($result[$enabledCharts[$i]] as $key => $info) {
                $chartInfo['cols'] = array_keys($result[$enabledCharts[$i]][$key]);
                break;
            }
          }
            for ($j = 0; $j < count($result[$enabledCharts[$i]]);  ++$j) {
                $chartInfo['rows'][$j] = array_values($result[$enabledCharts[$i]][$j]);
            }
            $chartData[$enabledCharts[$i]]['data'] = $chartInfo['rows'];
            if ($enabledCharts[$i] == 'OpenTicketsByPriority' || $enabledCharts[$i] == 'OpenCasesByPriority' || $enabledCharts[$i] == 'ProjectsByStatus') {
                $chartData[$enabledCharts[$i]]['type'] = 'pie';
            } else {
                $chartData[$enabledCharts[$i]]['type'] = 'spline';
            }
        }
        return $chartData;
    }

}
