<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_DescribeModule_API extends Portal_Default_API {

    public function process(Portal_Request $request) {

      
        $module = $request->getModule();
        $language = Portal_Session::get('language');
        $result = Vtiger_Connector::getInstance()->describeModule($module,$language);

        $response = new Portal_Response();
        $response->setResult($this->processResponse($result, $module));
        return $response;
    }

    /**
     * Funciton to preocess decribe response of contacts module
     * Change language picklist values to portal available languages
     * @param type $result
     * @param type $module
     * @return type
     */
    public function processResponse($result, $module) {
        if($module == 'Contacts') {
            foreach ($result['describe']['fields'] as $key => $fieldInfo) {
                if($fieldInfo['name'] == 'language' && $fieldInfo['type']['name'] == 'picklist'){
                    $fieldInfo['type']['picklistValues'] =  Portal_Config::get('languages');
                    $result['describe']['fields'][$key] = $fieldInfo;
                }
            }
        }
        return $result;
    }
}
