<?php
/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

include_once PORTAL_APP_DIR . '/libraries/Smarty/libs/Smarty.class.php';

class Portal_Viewer extends Smarty {

    function __construct() {
        parent::__construct();

        $compileDir = PORTAL_APP_DIR . '/writeable/templates_c/' . portal_layout();
        if (!file_exists($compileDir))
            mkdir($compileDir, 0755, true);

        $this->setTemplateDir(portal_layout_dir() . '/templates');
        $this->setCompileDir($compileDir);
    }

}

function portal_layout() {
    return Portal_Config::get('layout', 'default');
}

function portal_layout_dir() {
    return PORTAL_APP_DIR . '/layouts/' . Portal_Config::get('layout', 'default');
}

function portal_template_resolve($module, $file) {
    if (file_exists(portal_layout_dir() . "/templates/$module/$file")) {
        return "$module/$file";
    }
    return "Portal/$file";
}

function get_logo() {
    if (file_exists(Portal_Config::get('logo.path'))) {
        return Portal_Config::get('logo.path');
    } else {
        return 'layouts/' . portal_layout() . '/resources/images/logo.png';
    }
}

function portal_componentjs_class($module, $classPrefix){
    $file = portal_layout_dir()."/resources/components/$module.js";
    $jsclass = "{$module}_{$classPrefix}";
    if (file_exists($file) && stripos(file_get_contents($file), $jsclass) !== false) {
        return $jsclass;
    }
    // return $module;
    return "Portal_{$classPrefix}";
}

function portal_componentjs_file($module) {
    if (file_exists(portal_layout_dir() . "/resources/components/{$module}.js")) {
        return "layouts/" . portal_layout() . "/resources/components/{$module}.js";
    }
    return "";
}

function get_portal_version(){
  return Portal_Config::get('portal.version');
}

function getDefaultLanguage(){
    $sessionLanguage = Portal_Session::get('language');
    if($sessionLanguage !== ''){
        return $sessionLanguage;
    }else{
        $defaultLanguage = Portal_Config::get('ui.Language');
        return $defaultLanguage['value'];
    }  
}

function getDefaultDateFormat() {
	$sessionDateFormat = Portal_Session::get('owner_date_format');
	if($sessionDateFormat) {
		return $sessionDateFormat;
	}
	return 'yyyy-mm-dd';
}

function getDefaultTimeFormat() {
	$sessionTimeFormat = Portal_Session::get('owner_hour_format');
	if($sessionTimeFormat) {
		return $sessionTimeFormat;
	}
	return '24';
}